/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.adl.constraints;

import com.google.common.base.Joiner;
import com.nedap.archie.aom.primitives.CBoolean;
import com.nedap.archie.serializer.adl.ADLDefinitionSerializer;
import com.nedap.archie.serializer.adl.constraints.ConstraintSerializer;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class CBooleanSerializer
extends ConstraintSerializer<CBoolean> {
    public CBooleanSerializer(ADLDefinitionSerializer serializer) {
        super(serializer);
    }

    public static String capitalize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return Character.toString(Character.toUpperCase(str.charAt(0))) + str.substring(1);
    }

    @Override
    public void serialize(CBoolean cobj) {
        boolean constrained = false;
        ArrayList valids = new ArrayList();
        if (!cobj.getConstraint().isEmpty()) {
            valids.addAll(cobj.getConstraint().stream().map(aBoolean -> CBooleanSerializer.capitalize(aBoolean.toString().toLowerCase())).collect(Collectors.toList()));
        }
        if (!valids.isEmpty()) {
            this.builder.append(Joiner.on((String)", ").join(valids));
            constrained = true;
        }
        if (cobj.getAssumedValue() != null) {
            this.builder.append("; ").append(CBooleanSerializer.capitalize(cobj.getAssumedValue().toString()));
            constrained = true;
        }
        if (!constrained) {
            this.builder.append("*");
        }
    }

    @Override
    public boolean isEmpty(CBoolean cobj) {
        return cobj.getConstraint() == null || cobj.getConstraint().isEmpty();
    }
}

