/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.adl.constraints;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Joiner;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CDefinedObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.CPrimitiveTuple;
import com.nedap.archie.aom.DefaultValueContainer;
import com.nedap.archie.base.Cardinality;
import com.nedap.archie.base.OpenEHRBase;
import com.nedap.archie.rminfo.RMObjectMapperProvider;
import com.nedap.archie.serializer.adl.ADLDefinitionSerializer;
import com.nedap.archie.serializer.adl.ArchetypeSerializeUtils;
import com.nedap.archie.serializer.adl.constraints.ConstraintSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CComplexObjectSerializer<T extends CComplexObject>
extends ConstraintSerializer<T> {
    public CComplexObjectSerializer(ADLDefinitionSerializer serializer) {
        super(serializer);
    }

    @Override
    public void serialize(T cobj) {
        this.builder.indent().newline();
        this.appendSiblingOrder(cobj);
        this.builder.append(((CObject)cobj).getRmTypeName());
        if (((CObject)cobj).getNodeId() != null) {
            this.builder.append("[").append(((CObject)cobj).getNodeId()).append("]");
        }
        this.builder.append(" ");
        this.appendOccurrences(cobj);
        if (((CComplexObject)cobj).getAttributes().isEmpty() && ((CComplexObject)cobj).getAttributeTuples().isEmpty() && ((CDefinedObject)cobj).getDefaultValue() == null) {
            this.builder.lineComment(this.serializer.getTermText((CObject)cobj));
        } else {
            this.builder.append("matches {");
            this.builder.lineComment(this.serializer.getTermText((CObject)cobj));
            this.buildAttributesAndTuples(cobj);
            this.builder.append("}");
        }
        this.builder.unindent();
    }

    protected void buildAttributesAndTuples(T cobj) {
        this.builder.indent().newline();
        Set<String> tupleAttributes = this.getTupleAttributeNames(cobj);
        ((CComplexObject)cobj).getAttributes().stream().filter(a -> !tupleAttributes.contains(a.getRmAttributeName())).forEach(this::buildAttribute);
        ((CComplexObject)cobj).getAttributeTuples().forEach(this::buildTuple);
        this.buildDefaultValue(cobj);
        this.builder.unindent().newline();
    }

    protected void buildDefaultValue(T cobj) {
        if (((CDefinedObject)cobj).getDefaultValue() != null) {
            if (((CDefinedObject)cobj).getDefaultValue() instanceof DefaultValueContainer) {
                this.serializeDefaultValueContainer((DefaultValueContainer)((Object)((CDefinedObject)cobj).getDefaultValue()));
            } else {
                RMObjectMapperProvider rmObjectMapperProvider = this.serializer.getRmObjectMapperProvider();
                if (rmObjectMapperProvider == null || rmObjectMapperProvider.getOutputOdinObjectMapper() == null && rmObjectMapperProvider.getJsonObjectMapper() == null) {
                    this.builder.append("_default = ");
                    this.builder.newIndentedLine();
                    this.builder.odin(((CDefinedObject)cobj).getDefaultValue());
                    this.builder.newUnindentedLine();
                } else {
                    try {
                        String content;
                        String format;
                        if (rmObjectMapperProvider.getJsonObjectMapper() != null) {
                            format = "json";
                            content = rmObjectMapperProvider.getJsonObjectMapper().writerFor(OpenEHRBase.class).writeValueAsString(((CDefinedObject)cobj).getDefaultValue());
                        } else {
                            format = "odin";
                            content = rmObjectMapperProvider.getOutputOdinObjectMapper().writerFor(OpenEHRBase.class).writeValueAsString(((CDefinedObject)cobj).getDefaultValue());
                        }
                        this.serializeDefaultValueContainer(new DefaultValueContainer(format, content));
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    protected void serializeDefaultValueContainer(DefaultValueContainer container) {
        this.builder.tryNewLine();
        if (container.getFormat() == null || container.getFormat().equalsIgnoreCase("odin")) {
            this.builder.append("_default = ");
            this.builder.newIndentedLine();
            this.builder.appendMultipleLines(container.getContent());
            this.builder.unindent();
        } else {
            this.builder.append("_default = (");
            this.builder.append(container.getFormat());
            this.builder.append(") <#");
            if (container.getFormat().equalsIgnoreCase("json")) {
                this.builder.newIndentedLine();
                this.builder.appendMultipleLines(container.getContent());
                this.builder.unindent();
            } else {
                this.builder.append(container.getContent());
            }
            this.builder.append("#>");
        }
    }

    private Set<String> getTupleAttributeNames(T cobj) {
        return ((CComplexObject)cobj).getAttributeTuples().stream().flatMap(cat -> cat.getMembers().stream()).map(CAttribute::getRmAttributeName).collect(Collectors.toSet());
    }

    private void buildAttribute(CAttribute cattr) {
        this.builder.tryNewLine();
        if (cattr.getDifferentialPath() == null) {
            this.builder.append(cattr.getRmAttributeName());
        } else {
            this.builder.append(cattr.getDifferentialPath());
        }
        if (cattr.getExistence() != null) {
            this.builder.append(" existence matches {");
            ArchetypeSerializeUtils.buildOccurrences(this.builder, cattr.getExistence());
            this.builder.append("}");
        }
        if (cattr.getCardinality() != null) {
            this.builder.append(" cardinality matches {");
            this.appendCardinality(cattr.getCardinality());
            this.builder.append("}");
        }
        if (!cattr.getChildren().isEmpty()) {
            this.buildAttributeChildConstraints(cattr);
        }
    }

    private void buildTuple(CAttributeTuple cAttributeTuple) {
        this.builder.tryNewLine();
        this.builder.append("[");
        List members = cAttributeTuple.getMembers().stream().map(CAttribute::getRmAttributeName).collect(Collectors.toList());
        this.builder.append(Joiner.on((String)", ").join(members));
        this.builder.append("] matches {");
        this.builder.indent();
        for (int i = 0; i < cAttributeTuple.getTuples().size(); ++i) {
            CPrimitiveTuple cObjectTuple = cAttributeTuple.getTuples().get(i);
            this.builder.newline();
            this.builder.append("[");
            for (int j = 0; j < cObjectTuple.getMembers().size(); ++j) {
                this.builder.append("{");
                this.serializer.appendCObject((CObject)cObjectTuple.getMembers().get(j));
                this.builder.append("}");
                if (j >= cObjectTuple.getMembers().size() - 1) continue;
                this.builder.append(", ");
            }
            this.builder.append("]");
            if (i >= cAttributeTuple.getTuples().size() - 1) continue;
            this.builder.append(",");
        }
        this.builder.unindent().newline();
        this.builder.append("}");
    }

    private void buildAttributeChildConstraints(CAttribute cattr) {
        String commentText;
        List<CObject> children = this.filterNonEmptyChildren(cattr.getChildren());
        if (children.isEmpty()) {
            return;
        }
        this.builder.append(" matches ");
        boolean indent = !children.isEmpty() && (children.size() > 1 || !(children.get(0) instanceof CPrimitiveObject));
        this.builder.append("{");
        children.forEach(this.serializer::appendCObject);
        if (indent) {
            this.builder.newline();
        }
        this.builder.append("}");
        if (!indent && !children.isEmpty() && (commentText = this.serializer.getSimpleCommentText(children.get(0))) != null) {
            this.builder.lineComment(commentText);
        }
    }

    private List<CObject> filterNonEmptyChildren(List<CObject> children) {
        return children.stream().filter(child -> !this.serializer.isEmpty((CObject)child)).collect(Collectors.toList());
    }

    private void appendCardinality(Cardinality card) {
        ArchetypeSerializeUtils.buildOccurrences(this.builder, card.getInterval());
        ArrayList<String> tags = new ArrayList<String>();
        if (!card.isOrdered()) {
            tags.add("unordered");
        }
        if (card.isUnique()) {
            tags.add("unique");
        }
        if (!tags.isEmpty()) {
            this.builder.append("; ").append(Joiner.on((String)"; ").join(tags));
        }
    }
}

