/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.adl.constraints;

import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.primitives.COrdered;
import com.nedap.archie.base.Interval;
import com.nedap.archie.serializer.adl.ADLDefinitionSerializer;
import com.nedap.archie.serializer.adl.constraints.ConstraintSerializer;

public abstract class COrderedSerializer<T extends COrdered<?>>
extends ConstraintSerializer<T> {
    public COrderedSerializer(ADLDefinitionSerializer serializer) {
        super(serializer);
    }

    @Override
    public final void serialize(T cobj) {
        int original = this.builder.mark();
        this.serializeBefore(cobj);
        this.serializeConstraintIntervals(cobj);
        this.serializeAssumedValue(cobj);
        if (original == this.builder.mark()) {
            this.builder.append("*");
        }
        this.builder.clearMark();
    }

    protected void serializeBefore(T cobj) {
    }

    private void serializeAssumedValue(T cobj) {
        if (((CPrimitiveObject)cobj).getAssumedValue() != null && this.shouldIncludeAssumedValue(cobj)) {
            this.builder.append("; ").append(this.serializeConstraintValue(((CPrimitiveObject)cobj).getAssumedValue()));
        }
    }

    protected boolean shouldIncludeAssumedValue(T cobj) {
        return true;
    }

    private void serializeConstraintIntervals(T cobj) {
        if (!((CPrimitiveObject)cobj).getConstraint().isEmpty()) {
            boolean first = true;
            for (Interval interval : ((CPrimitiveObject)cobj).getConstraint()) {
                if (!first) {
                    this.builder.append(", ");
                }
                if (this.isSingleValueInterval(interval)) {
                    this.builder.append(this.serializeConstraintValue(interval.getLower()));
                } else {
                    this.builder.append(this.serializeInterval(interval));
                }
                first = false;
            }
        }
    }

    private String serializeInterval(Interval<?> interval) {
        if (interval.isLowerUnbounded()) {
            return "|" + (interval.isUpperIncluded() ? "<=" : "<") + this.serializeConstraintValue(interval.getUpper()) + "|";
        }
        if (interval.isUpperUnbounded()) {
            return "|" + (interval.isLowerIncluded() ? ">=" : ">") + this.serializeConstraintValue(interval.getLower()) + "|";
        }
        if (interval.getLower() != null && interval.getUpper() != null && interval.getLower() == interval.getUpper()) {
            return this.serializeConstraintValue(interval.getLower());
        }
        StringBuilder result = new StringBuilder();
        result.append("|");
        if (!interval.isLowerIncluded()) {
            result.append(">");
        }
        result.append(this.serializeConstraintValue(interval.getLower()));
        result.append("..");
        if (!interval.isUpperIncluded()) {
            result.append("<");
        }
        result.append(this.serializeConstraintValue(interval.getUpper()));
        result.append("|");
        return result.toString();
    }

    protected String serializeConstraintValue(Object value) {
        return value.toString();
    }

    private boolean isSingleValueInterval(Interval<?> interval) {
        return interval.getLower() != null && interval.isUpperIncluded() && interval.isLowerIncluded() && !interval.isLowerUnbounded() && !interval.isUpperUnbounded() && interval.getLower().equals(interval.getUpper());
    }

    @Override
    public boolean isEmpty(T object) {
        return ((CPrimitiveObject)object).getConstraint() == null || ((CPrimitiveObject)object).getConstraint().isEmpty();
    }
}

