/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.adl.constraints;

import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.primitives.CTemporal;
import com.nedap.archie.serializer.adl.ADLDefinitionSerializer;
import com.nedap.archie.serializer.adl.constraints.COrderedSerializer;

public abstract class CTemporalSerializer<T extends CTemporal<?>>
extends COrderedSerializer<T> {
    public CTemporalSerializer(ADLDefinitionSerializer serializer) {
        super(serializer);
    }

    @Override
    protected void serializeBefore(T cobj) {
        super.serializeBefore(cobj);
        this.serializePatternedConstraint(cobj);
    }

    private void serializePatternedConstraint(T cobj) {
        if (((CTemporal)cobj).getPatternConstraint() != null) {
            this.builder.append(((CTemporal)cobj).getPatternConstraint());
            if (!((CPrimitiveObject)cobj).getConstraint().isEmpty()) {
                this.builder.append("/");
            }
        }
    }

    @Override
    protected boolean shouldIncludeAssumedValue(T cobj) {
        boolean result = super.shouldIncludeAssumedValue(cobj);
        if (!result) {
            return false;
        }
        return ((CTemporal)cobj).getPatternConstraint() != null || ((CPrimitiveObject)cobj).getConstraint() != null && !((CPrimitiveObject)cobj).getConstraint().isEmpty();
    }
}

