/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.adl.constraints;

import com.nedap.archie.aom.primitives.CTerminologyCode;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.serializer.adl.ADLDefinitionSerializer;
import com.nedap.archie.serializer.adl.constraints.ConstraintSerializer;

public class CTerminologyCodeSerializer
extends ConstraintSerializer<CTerminologyCode> {
    public CTerminologyCodeSerializer(ADLDefinitionSerializer serializer) {
        super(serializer);
    }

    @Override
    public void serialize(CTerminologyCode cobj) {
        if (!cobj.getConstraint().isEmpty()) {
            if (cobj.getConstraintStatus() != null) {
                String constraintStatusString = null;
                switch (cobj.getConstraintStatus()) {
                    case REQUIRED: {
                        constraintStatusString = "required";
                        break;
                    }
                    case EXTENSIBLE: {
                        constraintStatusString = "extensible";
                        break;
                    }
                    case PREFERRED: {
                        constraintStatusString = "preferred";
                        break;
                    }
                    case EXAMPLE: {
                        constraintStatusString = "example";
                        break;
                    }
                    default: {
                        throw new RuntimeException("constraint status " + (Object)((Object)cobj.getConstraintStatus()) + " unknown, cannot be serialized");
                    }
                }
                this.builder.append(constraintStatusString);
                this.builder.append(" ");
            }
            this.builder.append("[");
            String constraint = cobj.getConstraint().get(0);
            this.builder.append(constraint);
            if (cobj.getAssumedValue() != null && cobj.getAssumedValue().getCodeString() != null) {
                this.builder.append("; ").append(cobj.getAssumedValue().getCodeString());
            }
            this.builder.append("]");
        }
    }

    @Override
    public String getSimpleCommentText(CTerminologyCode cobj) {
        String constraint;
        if (!cobj.getConstraint().isEmpty() && (AOMUtils.isValueSetCode(constraint = cobj.getConstraint().get(0)) || AOMUtils.isValueCode(constraint))) {
            return this.serializer.getTermText(cobj, constraint);
        }
        return null;
    }
}

