/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.adl.constraints;

import com.nedap.archie.aom.CObject;
import com.nedap.archie.serializer.adl.ADLDefinitionSerializer;
import com.nedap.archie.serializer.adl.ADLStringBuilder;
import com.nedap.archie.serializer.adl.ArchetypeSerializeUtils;

public abstract class ConstraintSerializer<T extends CObject> {
    protected final ADLDefinitionSerializer serializer;
    protected final ADLStringBuilder builder;

    public ConstraintSerializer(ADLDefinitionSerializer serializer) {
        this.serializer = serializer;
        this.builder = serializer.getBuilder();
    }

    public abstract void serialize(T var1);

    public String getSimpleCommentText(T cobj) {
        return null;
    }

    public boolean isEmpty(T cobj) {
        return false;
    }

    public void revert(int previousMark) {
        this.builder.revert(previousMark);
    }

    protected void appendOccurrences(T cobj) {
        if (((CObject)cobj).getOccurrences() != null) {
            this.builder.ensureSpace();
            this.builder.append("occurrences matches {");
            ArchetypeSerializeUtils.buildOccurrences(this.builder, ((CObject)cobj).getOccurrences());
            this.builder.append("} ");
        }
    }

    protected void appendSiblingOrder(T cobj) {
        if (((CObject)cobj).getSiblingOrder() != null) {
            this.builder.ensureSpace();
            this.builder.append(((CObject)cobj).getSiblingOrder().isBefore() ? "before" : "after");
            this.builder.append(" ");
            this.builder.append("[");
            this.builder.append(((CObject)cobj).getSiblingOrder().getSiblingNodeId());
            this.builder.append("]");
            this.builder.newline();
        }
    }
}

