/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.adl.rules;

import com.nedap.archie.rules.BinaryOperator;
import com.nedap.archie.serializer.adl.ADLRulesSerializer;
import com.nedap.archie.serializer.adl.rules.RuleElementSerializer;

public class BinaryOperatorSerializer
extends RuleElementSerializer<BinaryOperator> {
    public BinaryOperatorSerializer(ADLRulesSerializer serializer) {
        super(serializer);
    }

    @Override
    public void serialize(BinaryOperator operator) {
        switch (operator.getOperator()) {
            case implies: {
                this.serializer.serializeRuleElement(operator.getLeftOperand());
                this.builder.append(" ");
                this.builder.append(operator.getOperator().getDefaultCode());
                this.builder.newIndentedLine();
                this.serializer.serializeRuleElement(operator.getRightOperand());
                this.builder.unindent();
                break;
            }
            case eq: 
            case gt: 
            case lt: 
            case ne: 
            case le: 
            case ge: {
                this.serializer.serializeRuleElement(operator.getLeftOperand());
                this.builder.append(" ");
                this.builder.append(operator.getOperator().getDefaultCode());
                this.builder.append(" ");
                this.serializer.getBuilder().indent();
                this.serializer.serializeRuleElement(operator.getRightOperand());
                this.builder.unindent();
                break;
            }
            default: {
                this.serializer.serializeRuleElement(operator.getLeftOperand());
                this.builder.append(" ");
                this.builder.append(operator.getOperator().getDefaultCode());
                this.builder.append(" ");
                this.serializer.serializeRuleElement(operator.getRightOperand());
            }
        }
    }
}

