/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.xml.adapters;

import com.nedap.archie.datetime.DateTimeParsers;
import com.nedap.archie.datetime.DateTimeSerializerFormatters;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class DateTimeXmlAdapter
extends XmlAdapter<String, TemporalAccessor> {
    public TemporalAccessor unmarshal(String stringValue) {
        return stringValue != null ? DateTimeParsers.parseDateTimeValue((String)stringValue) : null;
    }

    public String marshal(TemporalAccessor value) {
        if (!(value.isSupported(ChronoField.HOUR_OF_DAY) || value.isSupported(ChronoField.MINUTE_OF_HOUR) || value.isSupported(ChronoField.SECOND_OF_MINUTE))) {
            return DateTimeSerializerFormatters.ISO_8601_DATE.format(value);
        }
        return DateTimeSerializerFormatters.ISO_8601_DATE_TIME.format(value);
    }
}

