/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.xml.adapters;

import com.nedap.archie.datetime.DateTimeParsers;
import com.nedap.archie.datetime.DateTimeSerializerFormatters;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.Temporal;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class DateXmlAdapter
extends XmlAdapter<String, Temporal> {
    public Temporal unmarshal(String stringValue) {
        return stringValue != null ? DateTimeParsers.parseDateValue((String)stringValue) : null;
    }

    public String marshal(Temporal value) {
        if (value instanceof LocalDate || value instanceof YearMonth) {
            return value.toString();
        }
        return value != null ? DateTimeSerializerFormatters.ISO_8601_DATE.format(value) : null;
    }
}

