/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.odin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openehr.odin.OdinAttribute;
import org.openehr.odin.OdinObject;
import org.openehr.odin.StringObject;

public class CompositeOdinObject
extends OdinObject
implements Serializable {
    private List<OdinAttribute> attributes = new ArrayList<OdinAttribute>();
    private Map<OdinObject, OdinObject> keyedObjects = new LinkedHashMap<OdinObject, OdinObject>();
    private Map<String, OdinAttribute> attributeIndex = new LinkedHashMap<String, OdinAttribute>();
    private String type;
    private boolean isList = false;

    public void addAttribute(OdinAttribute attribute) {
        this.attributes.add(attribute);
        this.attributeIndex.put(attribute.getName(), attribute);
    }

    public List<OdinAttribute> getAttributes() {
        ArrayList<OdinAttribute> attributeList = new ArrayList<OdinAttribute>();
        attributeList.addAll(this.attributes);
        return attributeList;
    }

    public OdinObject getKeyedObject(OdinObject key) {
        return this.keyedObjects.get(key);
    }

    public OdinObject getKeyedObject(String key) {
        return this.getKeyedObject(new StringObject(key));
    }

    public List<OdinObject> getKeyedObjects() {
        ArrayList<OdinObject> keyedObjects = new ArrayList<OdinObject>();
        keyedObjects.addAll(this.keyedObjects.values());
        return keyedObjects;
    }

    public Map<OdinObject, OdinObject> getKeyedObjectMap() {
        return this.keyedObjects;
    }

    public void addKeyedObject(OdinObject key, OdinObject type) {
        this.keyedObjects.put(key, type);
    }

    public OdinAttribute retrieveAttributeFromIndex(String attributeName) {
        return this.attributeIndex.get(attributeName);
    }

    public OdinAttribute getAttributeAtIndex(int index) {
        return this.attributes.get(index);
    }

    public OdinAttribute getAttribute(String attributeName) {
        return this.attributeIndex.get(attributeName);
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public int getKeyedObjectCount() {
        return this.keyedObjects.size();
    }

    public boolean isList() {
        return this.isList;
    }

    public void setList(boolean list) {
        this.isList = list;
    }

    public String toString() {
        return this.attributes.toString() + " -- " + this.keyedObjects;
    }
}

