/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.odin;

import java.io.Serializable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.openehr.odin.OdinObject;
import org.openehr.odin.PrimitiveObject;

public abstract class IntervalObject<T extends PrimitiveObject, U extends ParserRuleContext>
extends OdinObject
implements Serializable {
    private String intervalExpression;
    private T low;
    private T high;
    private boolean excludeUpperBound;
    private boolean excludeLowerBound;

    public String getIntervalExpression() {
        return this.intervalExpression;
    }

    public void setIntervalExpression(String intervalExpression) {
        this.intervalExpression = intervalExpression;
    }

    public T getLow() {
        return this.low;
    }

    public void setLow(T low) {
        this.low = low;
    }

    public T getHigh() {
        return this.high;
    }

    public void setHigh(T high) {
        this.high = high;
    }

    public boolean isExcludeUpperBound() {
        return this.excludeUpperBound;
    }

    public void setExcludeUpperBound(boolean excludeUpperBound) {
        this.excludeUpperBound = excludeUpperBound;
    }

    public boolean isExcludeLowerBound() {
        return this.excludeLowerBound;
    }

    public void setExcludeLowerBound(boolean excludeLowerBound) {
        this.excludeLowerBound = excludeLowerBound;
    }

    public boolean hasOpenLowerBound() {
        return this.getLow() == null;
    }

    public boolean hasOpenUpperBound() {
        return this.getHigh() == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleRelopExpression(ParserRuleContext ctx) {
        if (ctx.children.size() == 3) {
            this.setLow(this.extractFromContext((ParserRuleContext)ctx.children.get(1)));
            this.setHigh(this.extractFromContext((ParserRuleContext)ctx.children.get(1)));
            this.setExcludeLowerBound(false);
            this.setExcludeUpperBound(false);
            return;
        } else {
            if (ctx.children.size() != 4) throw new RuntimeException("Invalid number of children in parent context");
            String relops = ((ParseTree)ctx.children.get(1)).getText();
            if (relops.equals(">=")) {
                this.setLow(this.extractFromContext((ParserRuleContext)ctx.children.get(2)));
                this.setExcludeLowerBound(false);
                return;
            } else if (relops.equals("<=")) {
                this.setHigh(this.extractFromContext((ParserRuleContext)ctx.children.get(2)));
                this.setExcludeUpperBound(false);
                return;
            } else if (relops.equals(">")) {
                this.setLow(this.extractFromContext((ParserRuleContext)ctx.children.get(2)));
                this.setExcludeLowerBound(true);
                return;
            } else {
                if (!relops.equals("<")) throw new RuntimeException("Unknown relops " + relops);
                this.setHigh(this.extractFromContext((ParserRuleContext)ctx.children.get(2)));
                this.setExcludeUpperBound(true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleRangeExpression(ParserRuleContext ctx) {
        if (ctx.children.size() == 5) {
            this.setLow(this.extractFromContext((ParserRuleContext)ctx.children.get(1)));
            this.setHigh(this.extractFromContext((ParserRuleContext)ctx.children.get(3)));
            return;
        } else if (ctx.children.size() == 6) {
            if (((ParseTree)ctx.children.get(1)).getText().equals(">")) {
                this.setExcludeLowerBound(true);
                this.setExcludeUpperBound(false);
                this.setLow(this.extractFromContext((ParserRuleContext)ctx.children.get(2)));
                this.setHigh(this.extractFromContext((ParserRuleContext)ctx.children.get(4)));
                return;
            } else {
                if (!((ParseTree)ctx.children.get(3)).getText().equals("<")) throw new RuntimeException("Unknown grammar " + ctx.getText());
                this.setExcludeLowerBound(false);
                this.setExcludeUpperBound(true);
                this.setLow(this.extractFromContext((ParserRuleContext)ctx.children.get(1)));
                this.setHigh(this.extractFromContext((ParserRuleContext)ctx.children.get(4)));
            }
            return;
        } else {
            if (ctx.children.size() != 7) return;
            this.setExcludeLowerBound(true);
            this.setExcludeUpperBound(true);
            this.setLow(this.extractFromContext((ParserRuleContext)ctx.children.get(2)));
            this.setHigh(this.extractFromContext((ParserRuleContext)ctx.children.get(5)));
        }
    }

    protected abstract T extractFromContext(U var1);
}

