/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.odin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openehr.odin.BooleanObject;
import org.openehr.odin.CharObject;
import org.openehr.odin.CompositeOdinObject;
import org.openehr.odin.IntegerIntervalObject;
import org.openehr.odin.IntegerObject;
import org.openehr.odin.OdinObject;
import org.openehr.odin.PrimitiveObject;
import org.openehr.odin.RealObject;
import org.openehr.odin.StringObject;

public class OdinAttribute
implements Serializable {
    private String name;
    private List<OdinObject> children = new ArrayList<OdinObject>();

    public OdinAttribute() {
    }

    public OdinAttribute(String name) {
        this();
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addChild(OdinObject child) {
        this.children.add(child);
    }

    public boolean isPrimitiveValuedAttribute() {
        return this.children.size() == 1 && this.children.get(0) instanceof PrimitiveObject;
    }

    public boolean isPrimitiveList() {
        String type = this.children.get(0).getClass().getName();
        for (OdinObject child : this.children) {
            if (child instanceof PrimitiveObject || child.getClass().getName().equals(type)) continue;
            return false;
        }
        return true;
    }

    public PrimitiveObject<?> getPrimitiveObjectChild() {
        if (this.isPrimitiveValuedAttribute()) {
            return (PrimitiveObject)this.children.get(0);
        }
        return null;
    }

    public StringObject getStringObject() {
        if (this.isPrimitiveValuedAttribute() && this.getPrimitiveObjectChild() instanceof StringObject) {
            return (StringObject)this.children.get(0);
        }
        return null;
    }

    public String getStringValue() {
        return (String)this.getStringObject().getValue();
    }

    public List<String> getChildrenAsStringList() {
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.isPrimitiveList()) {
            for (OdinObject child : this.children) {
                retVal.add((String)((StringObject)child).getValue());
            }
        } else {
            throw new RuntimeException("Attribute must only have StringObject children");
        }
        return retVal;
    }

    public List<String> getChildrenAsStringList(boolean includeSingletons) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (this.isPrimitiveList()) {
            for (OdinObject child : this.children) {
                retVal.add((String)((StringObject)child).getValue());
            }
            if (retVal.size() == 2 && ((String)retVal.get(1)).equals("...")) {
                retVal.remove(1);
            }
        } else if (this.children.size() == 1 && this.children.get(0) instanceof StringObject) {
            retVal.add((String)((StringObject)this.children.get(0)).getValue());
        }
        return retVal;
    }

    public List<Integer> getChildrenAsIntegerList(boolean includeSingletons) {
        ArrayList<Integer> retVal = new ArrayList<Integer>();
        if (this.isPrimitiveList()) {
            for (OdinObject child : this.children) {
                retVal.add(((IntegerObject)child).getAsInteger());
            }
            if (retVal.size() == 2 && ((Integer)retVal.get(1)).equals("...")) {
                retVal.remove(1);
            }
        } else if (this.children.size() == 1 && this.children.get(0) instanceof IntegerObject) {
            retVal.add(((IntegerObject)this.children.get(0)).getAsInteger());
        }
        return retVal;
    }

    public StringObject getStringObjectAt(int index) {
        return (StringObject)this.children.get(index);
    }

    public String getStringValueAt(int index) {
        return (String)this.getStringObjectAt(index).getValue();
    }

    public OdinAttribute getChildAttribute(String attributeName) {
        OdinAttribute retVal = null;
        CompositeOdinObject attrBody = this.getSoleCompositeObjectBody();
        if (attrBody != null) {
            retVal = attrBody.getAttribute(attributeName);
        }
        return retVal;
    }

    public BooleanObject getBooleanObject() {
        if (this.isPrimitiveValuedAttribute() && this.getPrimitiveObjectChild() instanceof BooleanObject) {
            return (BooleanObject)this.children.get(0);
        }
        return null;
    }

    public Boolean getBooleanValue() {
        return (Boolean)this.getBooleanObject().getValue();
    }

    public RealObject getRealObject() {
        if (this.isPrimitiveValuedAttribute() && this.getPrimitiveObjectChild() instanceof RealObject) {
            return (RealObject)this.children.get(0);
        }
        return null;
    }

    public IntegerObject getIntegerObject() {
        if (this.isPrimitiveValuedAttribute() && this.getPrimitiveObjectChild() instanceof IntegerObject) {
            return (IntegerObject)this.children.get(0);
        }
        return null;
    }

    public IntegerIntervalObject getIntegerIntervalObject() {
        if (this.children.get(0) instanceof IntegerIntervalObject) {
            return (IntegerIntervalObject)this.children.get(0);
        }
        return null;
    }

    public CharObject getCharacterObject() {
        if (this.isPrimitiveValuedAttribute() && this.getPrimitiveObjectChild() instanceof CharObject) {
            return (CharObject)this.children.get(0);
        }
        return null;
    }

    public CompositeOdinObject getSoleCompositeObjectBody() {
        if (!this.isPrimitiveValuedAttribute() && this.children.size() == 1) {
            if (this.children.get(0) instanceof CompositeOdinObject) {
                return (CompositeOdinObject)this.children.get(0);
            }
            return null;
        }
        return null;
    }

    public List<OdinObject> getChildren() {
        return this.children;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public String toString() {
        return this.name;
    }
}

