/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.odin.antlr;

import com.nedap.archie.adlparser.antlr.odinBaseVisitor;
import com.nedap.archie.adlparser.antlr.odinParser;
import com.nedap.archie.adlparser.antlr.odinVisitor;
import com.nedap.archie.serializer.odin.OdinEmbeddedUriParser;
import java.util.Stack;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.openehr.odin.BooleanObject;
import org.openehr.odin.CharObject;
import org.openehr.odin.CompositeOdinObject;
import org.openehr.odin.DateIntervalObject;
import org.openehr.odin.DateObject;
import org.openehr.odin.DateTimeIntervalObject;
import org.openehr.odin.DateTimeObject;
import org.openehr.odin.DurationIntervalObject;
import org.openehr.odin.DurationObject;
import org.openehr.odin.IntegerIntervalObject;
import org.openehr.odin.IntegerObject;
import org.openehr.odin.OdinAttribute;
import org.openehr.odin.OdinObject;
import org.openehr.odin.OdinReferenceObject;
import org.openehr.odin.RealIntervalObject;
import org.openehr.odin.RealObject;
import org.openehr.odin.StringObject;
import org.openehr.odin.TermCodeObject;
import org.openehr.odin.TimeIntervalObject;
import org.openehr.odin.TimeObject;
import org.openehr.odin.UriObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdinVisitorImpl<T>
extends odinBaseVisitor<T>
implements odinVisitor<T> {
    private static Logger log = LoggerFactory.getLogger(OdinVisitorImpl.class);
    private Stack<Object> stack;

    public OdinVisitorImpl() {
        this.initializeStack();
    }

    public Stack<Object> getStack() {
        return this.stack;
    }

    private void initializeStack() {
        this.stack = new Stack();
    }

    public CompositeOdinObject getAstRootNode() {
        Object object;
        if (this.stack.size() == 1) {
            object = this.stack.pop();
            if (!(object instanceof CompositeOdinObject)) {
                throw new RuntimeException("Invalid root node type " + object.getClass().getName());
            }
        } else {
            throw new IllegalStateException("Stack should contain a single root node but contains " + this.stack.size() + " root nodes");
        }
        CompositeOdinObject root = (CompositeOdinObject)object;
        return root;
    }

    public T visitOdin_text(odinParser.Odin_textContext ctx) {
        this.visitOdin_text_pre(ctx);
        Object retVal = this.visitChildren((RuleNode)ctx);
        this.visitOdin_text_post(ctx);
        return (T)retVal;
    }

    private void visitOdin_text_pre(odinParser.Odin_textContext ctx) {
    }

    private void visitOdin_text_post(odinParser.Odin_textContext ctx) {
        log.debug("Final Stack: " + this.stack);
    }

    public T visitAttr_vals(odinParser.Attr_valsContext ctx) {
        this.visitAttr_vals_pre(ctx);
        Object retVal = this.visitChildren((RuleNode)ctx);
        this.visitAttr_vals_post(ctx);
        return (T)retVal;
    }

    private void visitAttr_vals_pre(odinParser.Attr_valsContext ctx) {
        if (this.stack.size() == 0) {
            this.addComplexObjectToStack(new CompositeOdinObject());
        }
    }

    private void visitAttr_vals_post(odinParser.Attr_valsContext ctx) {
        if (!(ctx.getParent() instanceof odinParser.Odin_textContext)) {
            if (this.stack.size() > 0 && this.stack.peek() instanceof OdinAttribute) {
                OdinAttribute attribute = (OdinAttribute)this.stack.peek();
                this.stack.pop();
            }
        } else {
            log.debug("Done processing");
        }
    }

    public T visitAttr_val(odinParser.Attr_valContext ctx) {
        this.visitAttr_val_pre(ctx);
        Object retVal = this.visitChildren((RuleNode)ctx);
        this.visitAttr_val_post(ctx);
        return (T)retVal;
    }

    private void visitAttr_val_pre(odinParser.Attr_valContext ctx) {
        String rm_attributeId = ctx.getChild(0).getText();
        OdinAttribute attribute = new OdinAttribute();
        attribute.setName(rm_attributeId);
        CompositeOdinObject complexObject = (CompositeOdinObject)this.stack.peek();
        complexObject.addAttribute(attribute);
        this.addAttributeToStack(attribute);
    }

    private void visitAttr_val_post(odinParser.Attr_valContext ctx) {
        this.stack.pop();
    }

    public T visitObject_block(odinParser.Object_blockContext ctx) {
        this.visitObject_block_pre(ctx);
        Object retVal = this.visitChildren((RuleNode)ctx);
        this.visitObject_block_post(ctx);
        return (T)retVal;
    }

    public void visitObject_block_pre(odinParser.Object_blockContext ctx) {
    }

    public void visitObject_block_post(odinParser.Object_blockContext ctx) {
        Object object = this.stack.peek();
        if (object instanceof CompositeOdinObject && !(ctx.getParent() instanceof odinParser.Keyed_objectContext)) {
            this.stack.pop();
        }
    }

    public T visitObject_value_block(odinParser.Object_value_blockContext ctx) {
        this.visitObject_value_block_pre(ctx);
        Object retVal = this.visitChildren((RuleNode)ctx);
        this.visitObject_value_block_post(ctx);
        return (T)retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitObject_value_block_pre(odinParser.Object_value_blockContext ctx) {
        ParseTree child;
        if (ctx.EMBEDDED_URI() != null) {
            Object object = this.getStack().peek();
            UriObject uri = new UriObject();
            uri.setValue(OdinEmbeddedUriParser.parseEmbeddedUri(ctx.EMBEDDED_URI().getText()));
            if (object instanceof OdinAttribute) {
                OdinAttribute attribute = (OdinAttribute)object;
                attribute.getChildren().add(uri);
                return;
            } else {
                if (!(object instanceof StringObject)) throw new RuntimeException("Invalid type " + object.getClass().getCanonicalName());
                this.getStack().push(uri);
            }
            return;
        }
        int index = 1;
        if (ctx.getChildCount() == 6) {
            index = 4;
        }
        if ((child = ctx.getChild(index)) instanceof odinParser.Keyed_objectContext) {
            Object object = this.stack.peek();
            if (object instanceof OdinAttribute) {
                OdinAttribute topAttribute = (OdinAttribute)object;
                CompositeOdinObject attributeBody = new CompositeOdinObject();
                topAttribute.addChild(attributeBody);
                this.stack.push(attributeBody);
                return;
            } else {
                if (!(object instanceof StringObject)) throw new RuntimeException("Invalid state: " + object.getClass().getName());
                this.stack.push(new CompositeOdinObject());
            }
            return;
        } else {
            if (!(child instanceof odinParser.Attr_valsContext)) return;
            CompositeOdinObject complexObject = new CompositeOdinObject();
            if (this.stack.size() > 0 && this.stack.peek() instanceof OdinAttribute) {
                OdinAttribute attribute = (OdinAttribute)this.stack.peek();
                attribute.addChild(complexObject);
            }
            this.addComplexObjectToStack(complexObject);
        }
    }

    public void visitObject_value_block_post(odinParser.Object_value_blockContext ctx) {
    }

    public T visitKeyed_object(odinParser.Keyed_objectContext ctx) {
        this.visitKeyed_object_pre(ctx);
        Object retVal = this.visitChildren((RuleNode)ctx);
        this.visitKeyed_object_post(ctx);
        return (T)retVal;
    }

    private void visitKeyed_object_pre(odinParser.Keyed_objectContext ctx) {
    }

    private void visitKeyed_object_post(odinParser.Keyed_objectContext ctx) {
        OdinObject value = (OdinObject)this.stack.pop();
        OdinObject key = (OdinObject)this.stack.pop();
        CompositeOdinObject body = (CompositeOdinObject)this.stack.peek();
        body.addKeyedObject(key, value);
    }

    public T visitPrimitive_object(odinParser.Primitive_objectContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitPrimitive_value(odinParser.Primitive_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitPrimitive_list_value(odinParser.Primitive_list_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitPrimitive_interval_value(odinParser.Primitive_interval_valueContext ctx) {
        this.visitPrimitive_interval_value_pre(ctx);
        Object retVal = this.visitChildren((RuleNode)ctx);
        this.visitPrimitive_interval_value_post(ctx);
        return (T)retVal;
    }

    private void visitPrimitive_interval_value_pre(odinParser.Primitive_interval_valueContext ctx) {
    }

    private void visitPrimitive_interval_value_post(odinParser.Primitive_interval_valueContext ctx) {
    }

    public T visitObject_reference_block(odinParser.Object_reference_blockContext ctx) {
        OdinReferenceObject result = new OdinReferenceObject();
        this.stack.push(result);
        Object retVal = this.visitChildren((RuleNode)ctx);
        return (T)retVal;
    }

    public T visitOdin_path_list(odinParser.Odin_path_listContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitOdin_path(odinParser.Odin_pathContext ctx) {
        OdinReferenceObject referenceObject = (OdinReferenceObject)this.stack.peek();
        if (ctx.ADL_PATH() != null) {
            referenceObject.getPaths().add(ctx.ADL_PATH().getText());
        } else {
            referenceObject.getPaths().add("/");
        }
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitString_value(odinParser.String_valueContext ctx) {
        this.visitString_value_pre(ctx);
        Object retVal = this.visitChildren((RuleNode)ctx);
        this.visitString_value_post(ctx);
        return (T)retVal;
    }

    private void visitString_value_pre(odinParser.String_valueContext ctx) {
        String value = this.removeDoubleQuotes(ctx.getText());
        Object topItem = this.stack.peek();
        if (topItem instanceof OdinAttribute) {
            OdinAttribute attribute = (OdinAttribute)this.stack.peek();
            StringObject cString = new StringObject();
            cString.setValue(value);
            attribute.getChildren().add(cString);
        } else {
            this.stack.push(new StringObject(value));
        }
    }

    private void visitString_value_post(odinParser.String_valueContext ctx) {
    }

    public T visitString_list_value(odinParser.String_list_valueContext ctx) {
        this.visitString_list_value_pre(ctx);
        Object retVal = this.visitChildren((RuleNode)ctx);
        this.visitString_list_value_post(ctx);
        return (T)retVal;
    }

    private void visitString_list_value_pre(odinParser.String_list_valueContext ctx) {
    }

    private void visitString_list_value_post(odinParser.String_list_valueContext ctx) {
    }

    public T visitTerminal(TerminalNode node) {
        this.visitTerminal_pre(node);
        Object retVal = super.visitTerminal(node);
        this.visitTerminal_post(node);
        return (T)retVal;
    }

    private void visitTerminal_pre(TerminalNode node) {
        String value;
        if (node.getParent() instanceof odinParser.String_list_valueContext && (value = node.getText()) != null && value.equals("...")) {
            OdinAttribute attribute = (OdinAttribute)this.stack.peek();
            StringObject cString = new StringObject();
            cString.setValue(value);
            attribute.getChildren().add(cString);
        }
    }

    private void visitTerminal_post(TerminalNode node) {
    }

    public T visitInteger_value(odinParser.Integer_valueContext ctx) {
        IntegerObject value = IntegerObject.extractIntegerObject(ctx);
        Object topItem = this.stack.peek();
        if (!(ctx.getParent() instanceof odinParser.Integer_interval_valueContext)) {
            if (topItem instanceof OdinAttribute) {
                OdinAttribute attribute = (OdinAttribute)topItem;
                attribute.getChildren().add(value);
            } else {
                this.stack.push(value);
            }
        }
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitInteger_list_value(odinParser.Integer_list_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitInteger_interval_value(odinParser.Integer_interval_valueContext ctx) {
        String intervalExpression = ctx.getText();
        IntegerIntervalObject integerInterval = new IntegerIntervalObject();
        integerInterval.setIntervalExpression(intervalExpression);
        OdinAttribute attribute = (OdinAttribute)this.stack.peek();
        attribute.addChild(integerInterval);
        if (ctx.children.get(1) instanceof odinParser.RelopContext) {
            integerInterval.handleRelopExpression((ParserRuleContext)ctx);
        } else {
            integerInterval.handleRangeExpression((ParserRuleContext)ctx);
        }
        Object retVal = this.visitChildren((RuleNode)ctx);
        return (T)retVal;
    }

    public T visitInteger_interval_list_value(odinParser.Integer_interval_list_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitReal_value(odinParser.Real_valueContext ctx) {
        if (!(ctx.getParent() instanceof odinParser.Real_interval_valueContext)) {
            String value = ctx.getText();
            OdinAttribute attribute = (OdinAttribute)this.stack.peek();
            RealObject cReal = new RealObject();
            cReal.setValue(value);
            attribute.getChildren().add(cReal);
        }
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitReal_list_value(odinParser.Real_list_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitReal_interval_value(odinParser.Real_interval_valueContext ctx) {
        String intervalExpression = ctx.getText();
        RealIntervalObject integerInterval = new RealIntervalObject();
        integerInterval.setIntervalExpression(intervalExpression);
        OdinAttribute attribute = (OdinAttribute)this.stack.peek();
        attribute.addChild(integerInterval);
        if (ctx.children.get(1) instanceof odinParser.RelopContext) {
            integerInterval.handleRelopExpression((ParserRuleContext)ctx);
        } else {
            integerInterval.handleRangeExpression((ParserRuleContext)ctx);
        }
        Object retVal = this.visitChildren((RuleNode)ctx);
        return (T)retVal;
    }

    public T visitReal_interval_list_value(odinParser.Real_interval_list_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitBoolean_value(odinParser.Boolean_valueContext ctx) {
        this.visitBoolean_value_pre(ctx);
        Object retVal = this.visitChildren((RuleNode)ctx);
        this.visitBoolean_value_post(ctx);
        return (T)retVal;
    }

    private void visitBoolean_value_pre(odinParser.Boolean_valueContext ctx) {
        String value = this.removeDoubleQuotes(ctx.getText());
        Boolean boolValue = Boolean.parseBoolean(value);
        OdinAttribute attribute = (OdinAttribute)this.stack.peek();
        BooleanObject cBoolean = new BooleanObject(boolValue);
        attribute.getChildren().add(cBoolean);
    }

    private void visitBoolean_value_post(odinParser.Boolean_valueContext ctx) {
    }

    public T visitBoolean_list_value(odinParser.Boolean_list_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitCharacter_value(odinParser.Character_valueContext ctx) {
        String value = this.removeSingleQuotes(ctx.getText());
        OdinAttribute attribute = (OdinAttribute)this.stack.peek();
        CharObject charObject = new CharObject();
        charObject.setValue(value);
        attribute.getChildren().add(charObject);
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitCharacter_list_value(odinParser.Character_list_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitDate_value(odinParser.Date_valueContext ctx) {
        if (!(ctx.getParent() instanceof odinParser.Date_interval_valueContext)) {
            String value = ctx.getText();
            OdinAttribute attribute = (OdinAttribute)this.stack.peek();
            DateObject date = new DateObject();
            date.setValue(value);
            attribute.getChildren().add(date);
        }
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitDate_list_value(odinParser.Date_list_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitDate_interval_value(odinParser.Date_interval_valueContext ctx) {
        String intervalExpression = ctx.getText();
        DateIntervalObject dateInterval = new DateIntervalObject();
        dateInterval.setIntervalExpression(intervalExpression);
        OdinAttribute attribute = (OdinAttribute)this.stack.peek();
        attribute.addChild(dateInterval);
        if (ctx.children.get(1) instanceof odinParser.RelopContext) {
            dateInterval.handleRelopExpression((ParserRuleContext)ctx);
        } else {
            dateInterval.handleRangeExpression((ParserRuleContext)ctx);
        }
        Object retVal = this.visitChildren((RuleNode)ctx);
        return (T)retVal;
    }

    public T visitDate_interval_list_value(odinParser.Date_interval_list_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitTime_value(odinParser.Time_valueContext ctx) {
        if (!(ctx.getParent() instanceof odinParser.Time_interval_valueContext)) {
            String value = ctx.getText();
            OdinAttribute attribute = (OdinAttribute)this.stack.peek();
            TimeObject timeObject = new TimeObject();
            timeObject.setValue(value);
            attribute.getChildren().add(timeObject);
        }
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitTime_list_value(odinParser.Time_list_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitTime_interval_value(odinParser.Time_interval_valueContext ctx) {
        String intervalExpression = ctx.getText();
        TimeIntervalObject timeInterval = new TimeIntervalObject();
        timeInterval.setIntervalExpression(intervalExpression);
        OdinAttribute attribute = (OdinAttribute)this.stack.peek();
        attribute.addChild(timeInterval);
        if (ctx.children.get(1) instanceof odinParser.RelopContext) {
            timeInterval.handleRelopExpression((ParserRuleContext)ctx);
        } else {
            timeInterval.handleRangeExpression((ParserRuleContext)ctx);
        }
        Object retVal = this.visitChildren((RuleNode)ctx);
        return (T)retVal;
    }

    public T visitTime_interval_list_value(odinParser.Time_interval_list_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitDate_time_value(odinParser.Date_time_valueContext ctx) {
        if (!(ctx.getParent() instanceof odinParser.Date_time_interval_valueContext)) {
            String value = ctx.getText();
            OdinAttribute attribute = (OdinAttribute)this.stack.peek();
            DateTimeObject dateTime = new DateTimeObject();
            dateTime.setValue(value);
            attribute.getChildren().add(dateTime);
        }
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitDate_time_list_value(odinParser.Date_time_list_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitDate_time_interval_value(odinParser.Date_time_interval_valueContext ctx) {
        String intervalExpression = ctx.getText();
        DateTimeIntervalObject dateTimeInterval = new DateTimeIntervalObject();
        dateTimeInterval.setIntervalExpression(intervalExpression);
        OdinAttribute attribute = (OdinAttribute)this.stack.peek();
        attribute.addChild(dateTimeInterval);
        if (ctx.children.get(1) instanceof odinParser.RelopContext) {
            dateTimeInterval.handleRelopExpression((ParserRuleContext)ctx);
        } else {
            dateTimeInterval.handleRangeExpression((ParserRuleContext)ctx);
        }
        Object retVal = this.visitChildren((RuleNode)ctx);
        return (T)retVal;
    }

    public T visitDate_time_interval_list_value(odinParser.Date_time_interval_list_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitDuration_value(odinParser.Duration_valueContext ctx) {
        if (!(ctx.getParent() instanceof odinParser.Duration_interval_valueContext)) {
            String value = ctx.getText();
            OdinAttribute attribute = (OdinAttribute)this.stack.peek();
            DurationObject duration = new DurationObject();
            duration.setValue(value);
            attribute.getChildren().add(duration);
        }
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitDuration_list_value(odinParser.Duration_list_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitDuration_interval_value(odinParser.Duration_interval_valueContext ctx) {
        String intervalExpression = ctx.getText();
        DurationIntervalObject durationInterval = new DurationIntervalObject();
        durationInterval.setIntervalExpression(intervalExpression);
        OdinAttribute attribute = (OdinAttribute)this.stack.peek();
        attribute.addChild(durationInterval);
        if (ctx.children.get(1) instanceof odinParser.RelopContext) {
            durationInterval.handleRelopExpression((ParserRuleContext)ctx);
        } else {
            durationInterval.handleRangeExpression((ParserRuleContext)ctx);
        }
        Object retVal = this.visitChildren((RuleNode)ctx);
        return (T)retVal;
    }

    public T visitDuration_interval_list_value(odinParser.Duration_interval_list_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitTerm_code_value(odinParser.Term_code_valueContext ctx) {
        String value = ctx.getText();
        OdinAttribute attribute = (OdinAttribute)this.stack.peek();
        TermCodeObject termCode = new TermCodeObject();
        termCode.setValue(value);
        attribute.getChildren().add(termCode);
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitTerm_code_list_value(odinParser.Term_code_list_valueContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitRelop(odinParser.RelopContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitType_id(odinParser.Type_idContext ctx) {
        String value = ctx.getText();
        CompositeOdinObject complexObject = (CompositeOdinObject)this.stack.peek();
        if (complexObject.getType() == null) {
            complexObject.setType(value);
        }
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitAttribute_id(odinParser.Attribute_idContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitIdentifier(odinParser.IdentifierContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public T visitArchetype_ref(odinParser.Archetype_refContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    private String removeDoubleQuotes(String input) {
        return input.replaceAll("(^\")|(\"$)", "");
    }

    private String removeSingleQuotes(String input) {
        return input.replaceAll("(^')|('$)", "");
    }

    private boolean isStackEmpty() {
        return this.stack.size() == 0;
    }

    private void addComplexObjectToStack(CompositeOdinObject compositeObject) {
        this.stack.push(compositeObject);
    }

    private void addAttributeToStack(OdinAttribute attribute) {
        this.stack.push(attribute);
    }

    private void addStringToStack(String string) {
        this.stack.push(string);
    }
}

