/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.odin.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.nedap.archie.base.Interval;
import com.nedap.archie.base.terminology.TerminologyCode;
import java.net.URI;
import java.net.URL;
import org.openehr.odin.jackson.ODINFactory;
import org.openehr.odin.jackson.ODINGenerator;
import org.openehr.odin.jackson.serializers.OdinIntegerMapKeySerializer;
import org.openehr.odin.jackson.serializers.OdinIntervalSerializer;
import org.openehr.odin.jackson.serializers.OdinLongMapKeySerializer;
import org.openehr.odin.jackson.serializers.OdinStringMapKeySerializer;
import org.openehr.odin.jackson.serializers.OdinURISerializer;
import org.openehr.odin.jackson.serializers.OdinURLSerializer;
import org.openehr.odin.jackson.serializers.TerminologyCodeSerializer;

public class ODINMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public ODINMapper() {
        this(new ODINFactory(new MappingJsonFactory()));
        this.getFactory().setCodec((ObjectCodec)this);
    }

    public ODINMapper(ODINFactory f) {
        super((JsonFactory)f);
        this.setup();
    }

    public ODINMapper(ODINMapper base) {
        super((ObjectMapper)base);
        this.setup();
    }

    private void setup() {
        this.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        this.disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        this.disable(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
        this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.enableDefaultTyping(ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT);
        SimpleModule odinModule = new SimpleModule();
        odinModule.addKeySerializer(String.class, (JsonSerializer)new OdinStringMapKeySerializer());
        odinModule.addKeySerializer(Integer.class, (JsonSerializer)new OdinIntegerMapKeySerializer());
        odinModule.addKeySerializer(Long.class, (JsonSerializer)new OdinLongMapKeySerializer());
        odinModule.addSerializer(Interval.class, (JsonSerializer)new OdinIntervalSerializer());
        odinModule.addSerializer(URI.class, (JsonSerializer)new OdinURISerializer());
        odinModule.addSerializer(URL.class, (JsonSerializer)new OdinURLSerializer());
        odinModule.addSerializer(TerminologyCode.class, (JsonSerializer)new TerminologyCodeSerializer());
        this.registerModule((Module)odinModule);
    }

    public ODINMapper copy() {
        this._checkInvalidCopy(ODINMapper.class);
        return new ODINMapper(this);
    }

    public ODINMapper configure(ODINGenerator.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public ODINMapper enable(ODINGenerator.Feature f) {
        ((ODINFactory)this._jsonFactory).enable(f);
        return this;
    }

    public ODINMapper disable(ODINGenerator.Feature f) {
        ((ODINFactory)this._jsonFactory).disable(f);
        return this;
    }

    public ODINMapper disable(JsonParser.Feature f) {
        ((ODINFactory)this._jsonFactory).disable(f);
        return this;
    }

    public final ODINFactory getFactory() {
        return (ODINFactory)this._jsonFactory;
    }
}

