/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.odin.loader;

import com.nedap.archie.adlparser.antlr.odinLexer;
import com.nedap.archie.adlparser.antlr.odinParser;
import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import com.nedap.archie.antlr.errors.ArchieErrorListener;
import java.io.IOException;
import java.io.InputStream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.openehr.odin.antlr.OdinVisitorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OdinLoaderImpl {
    private static Logger log = LoggerFactory.getLogger(OdinLoaderImpl.class);

    public OdinVisitorImpl loadOdinFile(String bmmFilePath) {
        try {
            return this.loadOdinFile(CharStreams.fromFileName((String)bmmFilePath));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            log.error("Error loading reference model", (Throwable)ioe);
            throw new RuntimeException("Error loading reference model", ioe);
        }
    }

    public OdinVisitorImpl loadOdinFromString(String odinContent) {
        return this.loadOdinFile((CharStream)CharStreams.fromString((String)odinContent));
    }

    public OdinVisitorImpl loadOdinFile(InputStream inputStream) {
        try {
            return this.loadOdinFile(CharStreams.fromStream((InputStream)inputStream));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            log.error("Error loading odin file", (Throwable)ioe);
            throw new RuntimeException("Error loading odin file", ioe);
        }
    }

    public OdinVisitorImpl loadOdinFile(CharStream input) {
        OdinVisitorImpl visitor = new OdinVisitorImpl();
        odinLexer lexer = new odinLexer(input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        odinParser parser = new odinParser((TokenStream)tokens);
        ANTLRParserErrors errors = new ANTLRParserErrors();
        ArchieErrorListener listener = new ArchieErrorListener(errors);
        parser.addErrorListener((ANTLRErrorListener)listener);
        odinParser.Odin_textContext tree = parser.odin_text();
        visitor.visit((ParseTree)tree);
        if (errors.hasErrors()) {
            throw new RuntimeException("errors parsing ODIN file: " + errors);
        }
        return visitor;
    }
}

