/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.odin.utils;

import java.util.ArrayList;
import java.util.List;
import org.openehr.odin.IntegerIntervalObject;

public class OdinSerializationUtils {
    public static String buildOdinStringObject(String content) {
        return "<\"" + content + "\">";
    }

    public static String buildOdinBooleanObject(Boolean bool) {
        if (bool.booleanValue()) {
            return "<True>";
        }
        return "<False>";
    }

    public static String buildOdinObjectDeclaration(String objectName) {
        return objectName + " = <\n";
    }

    public static String buildOdinStringObjectPropertyInitialization(String propertyName, String content) {
        return propertyName + " = " + OdinSerializationUtils.buildOdinStringObject(content) + "\n";
    }

    public static String buildOdinBooleanObjectPropertyInitialization(String propertyName, Boolean bool) {
        return propertyName + " = " + OdinSerializationUtils.buildOdinBooleanObject(bool) + "\n";
    }

    public static String buildOdinCardinalityInitialization(String propertyName, IntegerIntervalObject cardinality) {
        return propertyName + " = <" + cardinality.toString() + ">\n";
    }

    public static String buildOdinCommentBlockSeparator() {
        return "-- ----------------------------------\n";
    }

    public static String buildOdinComment(String commentText) {
        return "-- " + commentText + "\n";
    }

    public static String buildOdinCommentBlock(String ... commentBlock) {
        return OdinSerializationUtils.buildOdinCommentBlock(0, commentBlock);
    }

    public static String buildOdinCommentBlock(int indentLevel, String ... commentBlock) {
        StringBuilder builder = new StringBuilder();
        String indents = OdinSerializationUtils.indentByTabCount(indentLevel);
        builder.append(indents).append(OdinSerializationUtils.buildOdinCommentBlockSeparator());
        for (String comment : commentBlock) {
            builder.append(indents).append(OdinSerializationUtils.buildOdinComment(comment));
        }
        builder.append(indents).append(OdinSerializationUtils.buildOdinCommentBlockSeparator());
        return builder.toString();
    }

    public static String buildOdinStringList(List<String> items) {
        ArrayList<String> elements = new ArrayList<String>();
        elements.addAll(items);
        if (items.size() > 0 && items.get(items.size() - 1).equals("...")) {
            elements.remove(items.size() - 1);
        }
        StringBuilder builder = new StringBuilder("<");
        for (int i = 0; i < elements.size(); ++i) {
            String item = (String)elements.get(i);
            builder.append("\"").append(item).append("\"");
            if (i >= elements.size() - 1) continue;
            builder.append(", ");
        }
        OdinSerializationUtils.handleListEnding(elements, builder);
        return builder.toString();
    }

    public static String buildOdinStringListPropertyInitialization(String propertyName, List<String> content) {
        return propertyName + " = " + OdinSerializationUtils.buildOdinStringList(content) + "\n";
    }

    public static String buildOdinIntegerList(List<Integer> items) {
        ArrayList<Integer> elements = new ArrayList<Integer>();
        elements.addAll(items);
        if (items.size() > 0 && items.get(items.size() - 1).equals("...")) {
            elements.remove(items.size() - 1);
        }
        StringBuilder builder = new StringBuilder("<");
        for (int i = 0; i < elements.size(); ++i) {
            Integer item = (Integer)elements.get(i);
            builder.append(item);
            if (i >= elements.size() - 1) continue;
            builder.append(", ");
        }
        OdinSerializationUtils.handleListEnding(elements, builder);
        return builder.toString();
    }

    public static String buildOdinIntegerListPropertyInitialization(String propertyName, List<Integer> content) {
        return propertyName + " = " + OdinSerializationUtils.buildOdinIntegerList(content) + "\n";
    }

    protected static void handleListEnding(List<?> elements, StringBuilder builder) {
        int itemCount = elements.size();
        if (itemCount == 0) {
            builder.append("...>");
        } else if (itemCount == 1) {
            builder.append(",...>");
        } else {
            builder.append(">");
        }
    }

    public static String indentByTabCount(int tabCount) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tabCount; ++i) {
            builder.append("\t");
        }
        return builder.toString();
    }

    public static String buildKeyedObjectOpeningDeclaration(String key) {
        StringBuilder builder = new StringBuilder();
        builder.append("[\"").append(key).append("\"] = <").append("\n");
        return builder.toString();
    }

    public static String buildKeyedObjectOpeningDeclarationWithCast(String key, String cast) {
        StringBuilder builder = new StringBuilder();
        builder.append("[\"").append(key).append("\"] = ").append("(").append(cast).append(") <").append("\n");
        return builder.toString();
    }

    public static String buildKeyedStringObjectdeclaration(String key, String value) {
        StringBuilder builder = new StringBuilder();
        builder.append("[\"").append(key).append("\"] = ").append("<\"").append(value).append("\">").append("\n");
        return builder.toString();
    }

    public static String buildOpeningDeclarationWithCast(String cast) {
        StringBuilder builder = new StringBuilder();
        builder.append("(").append(cast).append(") <").append("\n");
        return builder.toString();
    }

    public static String buildObjectOpeningDeclaration(String objectName) {
        StringBuilder builder = new StringBuilder();
        builder.append(objectName).append(" = <").append("\n");
        return builder.toString();
    }

    public static String buildObjectOpeningDeclarationWithCast(String objectName, String cast) {
        StringBuilder builder = new StringBuilder();
        builder.append(objectName).append(" = (").append(cast).append(") <").append("\n");
        return builder.toString();
    }

    public static String closeOdinObject() {
        StringBuilder builder = new StringBuilder();
        builder.append(">\n");
        return builder.toString();
    }
}

