/*
 * Decompiled with CFR 0.152.
 */
package com.needhamsoftware.unojar.ant;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class UnoJarTask
extends Jar {
    public static final List<Object> DEBUGTMP = new ArrayList<Object>();
    public static final int BUFFER_SIZE = 8192;
    public static final String META_INF_MANIFEST = "META-INF/MANIFEST.MF";
    public static final String MAIN_MAIN_JAR = "main/main.jar";
    public static final String CLASS = ".class";
    public static final String NL = "\n";
    public static final String MAIN_CLASS = Attributes.Name.MAIN_CLASS.toString();
    protected Main main;
    protected MainJars mainJars;
    protected ZipFile onejar;
    protected File mainManifest;
    protected String oneJarMainClass;
    protected boolean manifestSet;
    protected byte[] buf = new byte[8192];

    public UnoJarTask() {
    }

    public UnoJarTask(String project) {
        this.setTaskName("uno-jar");
        this.setProject(new Project());
        this.getProject().setName(project);
    }

    public void setBootManifest(File manifest) {
        this.log("setBootManifest(" + manifest + ")", 3);
        super.setManifest(manifest);
    }

    public void setMainManifest(File manifest) {
        this.mainManifest = manifest;
        this.log("setMainManifest(" + manifest + ")", 3);
    }

    public void setOneJarMainClass(String main) {
        this.oneJarMainClass = main;
    }

    public void setOneJarBoot(ZipFile jar) {
        this.log("setOneJarBoot(" + jar + ")", 3);
        this.onejar = jar;
    }

    public void addBoot(ZipFileSet files) {
        this.log("addBoot()", 3);
        super.addFileset((FileSet)files);
    }

    public void addMain(Main main) {
        this.log("addMain()", 3);
        this.main = main;
    }

    public void addConfiguredLib(Lib lib) {
        this.log("addLib()", 3);
        for (ZipFileSet fileset : lib.filesets) {
            fileset.setPrefix("lib/");
            super.addFileset((FileSet)fileset);
        }
    }

    public void addConfiguredManifest(org.apache.tools.ant.taskdefs.Manifest newManifest) throws ManifestException {
        super.addConfiguredManifest(newManifest);
        this.manifestSet = true;
    }

    public void addConfiguredMainJars(MainJars jars) {
        this.mainJars = jars;
        this.log("addMainJar()", 3);
        for (ZipFileSet fileset : jars.filesets) {
            fileset.setPrefix("main/");
            super.addFileset((FileSet)fileset);
        }
    }

    public void addConfiguredBinLib(BinLib lib) {
        this.log("addBinLib()", 3);
        for (ZipFileSet fileset : lib.filesets) {
            fileset.setPrefix("binlib/");
            super.addFileset((FileSet)fileset);
        }
    }

    protected void includeZip(ZipFile zip, ZipOutputStream zOut) {
        try {
            Enumeration<? extends java.util.zip.ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                java.util.zip.ZipEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(CLASS) && !entry.getName().equals(".version")) continue;
                this.log("ZipPump: " + entry.getName(), 4);
                super.zipFile(zip.getInputStream(entry), zOut, entry.getName(), System.currentTimeMillis(), null, 33188);
            }
        }
        catch (IOException iox) {
            throw new BuildException((Throwable)iox);
        }
    }

    protected void copy(InputStream is, OutputStream os, boolean closein) throws IOException {
        int len = -1;
        while ((len = is.read(this.buf)) >= 0) {
            os.write(this.buf, 0, len);
        }
        if (closein) {
            is.close();
        }
    }

    protected void copy(String s, OutputStream os) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
        this.copy(bais, os, true);
    }

    public void setManifest(File manifestFile) {
        super.setManifest(manifestFile);
        this.manifestSet = true;
    }

    protected void checkMain() {
        if (this.mainJars == null && this.main == null) {
            throw new BuildException("No <main> or <mainjars> element found in the <uno-jar> task!");
        }
    }

    protected void checkManifest() {
        if (!this.manifestSet) {
            this.log("No 'manifest' attribute was specified for the <uno-jar> task, a default manifest will be generated.", 1);
        }
    }

    protected void addOneJarBoot(ZipOutputStream zOut) throws IOException {
        if (zOut == null) {
            return;
        }
        if (this.onejar != null) {
            this.includeZip(this.onejar, zOut);
        } else {
            String ONE_JAR_BOOT = "core.jar";
            InputStream is = UnoJarTask.class.getResourceAsStream(ONE_JAR_BOOT);
            if (is == null) {
                throw new IOException("Unable to load default " + ONE_JAR_BOOT + ": consider using the <uno-jar onejarboot=\"...\"> option.");
            }
            JarInputStream jis = new JarInputStream(is);
            org.apache.tools.ant.taskdefs.Manifest manifest = new org.apache.tools.ant.taskdefs.Manifest();
            Manifest jmanifest = jis.getManifest();
            Attributes jattributes = jmanifest.getMainAttributes();
            try {
                manifest.addConfiguredAttribute(new Manifest.Attribute("Archive-Type", "uno-jar"));
                manifest.addConfiguredAttribute(new Manifest.Attribute(MAIN_CLASS, jattributes.getValue(MAIN_CLASS)));
                if (this.oneJarMainClass != null) {
                    manifest.addConfiguredAttribute(new Manifest.Attribute("Uno-Jar-Main-Class", this.oneJarMainClass));
                }
                super.addConfiguredManifest(manifest);
            }
            catch (ManifestException mx) {
                throw new BuildException((Throwable)mx);
            }
            super.initZipOutputStream(zOut);
            java.util.zip.ZipEntry entry = jis.getNextEntry();
            while (entry != null) {
                if (entry.getName().endsWith(CLASS) || entry.getName().equals(".version") || entry.getName().endsWith("LICENSE.txt") || entry.getName().endsWith("NOTICE.txt")) {
                    this.log("entry=" + entry.getName(), 4);
                    zOut.putNextEntry(new ZipEntry(entry));
                    this.copy(jis, (OutputStream)zOut, false);
                }
                entry = jis.getNextJarEntry();
            }
        }
    }

    protected void addMain(ZipOutputStream zOut) throws IOException {
        if (this.main == null || this.main.jar != null) {
            return;
        }
        FileSetPump pump = new FileSetPump(MAIN_MAIN_JAR);
        pump.start();
        super.zipFile((InputStream)pump.pin, zOut, MAIN_MAIN_JAR, System.currentTimeMillis(), null, 33188);
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException {
        this.checkMain();
        this.checkManifest();
        this.addOneJarBoot(zOut);
        this.addMain(zOut);
    }

    public void execute() throws BuildException {
        this.log("execute()", 3);
        if (this.main != null && this.main.jar != null) {
            ZipFileSet fs = new ZipFileSet();
            fs.setProject(this.getProject());
            fs.setFile(this.main.jar);
            fs.setPrefix("main/");
            System.out.println("main.jar fs=" + fs);
            super.addFileset((FileSet)fs);
        }
        super.execute();
    }

    protected void zipFile(InputStream is, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException {
        if (vPath.equals(MAIN_MAIN_JAR) && (this.main == null || this.main.jar == null)) {
            this.log("zipFile(): unable to build main/main.jar", 3);
        } else {
            super.zipFile(is, zOut, vPath, lastModified, fromArchive, mode);
        }
    }

    protected class FileSetPump
    extends PipedThread {
        protected String target;

        public FileSetPump(String target) {
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (UnoJarTask.this.main != null) {
                Iterator iter = UnoJarTask.this.main.filesets.iterator();
                java.util.zip.ZipOutputStream zout = new java.util.zip.ZipOutputStream(this.pout);
                try {
                    java.util.zip.ZipEntry m = new java.util.zip.ZipEntry(UnoJarTask.META_INF_MANIFEST);
                    zout.putNextEntry(m);
                    if (UnoJarTask.this.main.manifest != null) {
                        UnoJarTask.this.copy(new FileInputStream(UnoJarTask.this.main.manifest), zout, true);
                    } else if (UnoJarTask.this.mainManifest != null) {
                        UnoJarTask.this.copy(new FileInputStream(UnoJarTask.this.mainManifest), zout, true);
                    }
                    zout.closeEntry();
                    while (iter.hasNext()) {
                        FileSet fileset = (FileSet)iter.next();
                        DirectoryScanner scanner = fileset.getDirectoryScanner(UnoJarTask.this.getProject());
                        String[] files = scanner.getIncludedFiles();
                        File basedir = scanner.getBasedir();
                        for (int i = 0; i < files.length; ++i) {
                            String dirs;
                            String file = files[i].replace('\\', '/');
                            if (this.entries.contains(file)) {
                                UnoJarTask.this.log("Duplicate entry " + this.target + " (ignored): " + file, 1);
                                continue;
                            }
                            this.entries.add(file);
                            String p = new File(file).getParent();
                            if (p != null && !this.entries.contains(dirs = p.replace('\\', '/'))) {
                                String[] toks = dirs.split("/");
                                Object dir = "";
                                for (int d = 0; d < toks.length; ++d) {
                                    if (this.entries.contains(dir = (String)dir + toks[d] + "/")) continue;
                                    java.util.zip.ZipEntry ze = new java.util.zip.ZipEntry((String)dir);
                                    zout.putNextEntry(ze);
                                    zout.flush();
                                    zout.closeEntry();
                                    this.entries.add(dir);
                                }
                                this.entries.add(dir);
                            }
                            java.util.zip.ZipEntry ze = new java.util.zip.ZipEntry(file);
                            zout.putNextEntry(ze);
                            UnoJarTask.this.log("processing " + file, 4);
                            FileInputStream fis = new FileInputStream(new File(basedir, file));
                            UnoJarTask.this.copy(fis, zout, true);
                            zout.closeEntry();
                        }
                    }
                    zout.close();
                    FileSetPump fileSetPump = this;
                    synchronized (fileSetPump) {
                        this.done = true;
                        this.notify();
                    }
                }
                catch (IOException iox) {
                    throw new BuildException((Throwable)iox);
                }
            }
        }
    }

    protected class PipedThread
    extends Thread {
        protected boolean done = false;
        protected PipedInputStream pin = new PipedInputStream();
        protected PipedOutputStream pout = new PipedOutputStream();
        protected Set entries = new HashSet();

        public PipedThread() {
            try {
                this.pin.connect(this.pout);
            }
            catch (IOException iox) {
                throw new BuildException((Throwable)iox);
            }
        }
    }

    public static class BinLib
    extends Task {
        protected List filesets = new ArrayList();

        public void addFileSet(ZipFileSet fileset) {
            this.log("BinLib.addFileSet() ", 3);
            this.filesets.add(fileset);
        }
    }

    public static class Lib
    extends Task {
        protected List filesets = new ArrayList();

        public void addFileSet(ZipFileSet fileset) {
            this.log("Lib.addFileSet() ", 3);
            this.filesets.add(fileset);
        }

        public void addConfiguredClasspath(Path classpath) {
            this.log("adding classpath: " + classpath, 3);
            for (Resource res : classpath) {
                if (res instanceof FileResource) {
                    FileResource fres = (FileResource)res;
                    this.log("res.name: " + fres.getName() + " res.exists: " + fres.isExists() + " res.class: " + fres.getClass().getName() + " res.file: " + fres.getFile(), 4);
                    File dir = fres.getFile().getParentFile();
                    String name = fres.getFile().getName();
                    ZipFileSet fileset = new ZipFileSet();
                    fileset.setProject(this.getProject());
                    fileset.setDir(dir);
                    fileset.createInclude().setName(name);
                    this.filesets.add(fileset);
                    continue;
                }
                throw new BuildException("Not a file resource: " + res);
            }
        }
    }

    public static class MainJars
    extends Task {
        List<ZipFileSet> filesets = new ArrayList<ZipFileSet>();
        protected String app;

        public void addFileSet(ZipFileSet fileset) {
            this.log("MainJar.addFileSet() ", 3);
            this.filesets.add(fileset);
        }
    }

    public static class Main
    extends Task {
        protected List filesets = new ArrayList();
        protected File manifest;
        protected File jar;

        public void setManifest(File manifest) {
            this.manifest = manifest;
        }

        public void addFileSet(FileSet fileset) {
            if (this.jar != null) {
                throw new BuildException("'jar' attribute is mutually exclusive to use of <fileset>");
            }
            this.log("Main.addFileSet() ", 3);
            this.filesets.add(fileset);
        }

        public void setJar(File main) {
            this.jar = main;
        }
    }
}

