/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.nacos.configuration;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.nepxion.discovery.common.nacos.operation.NacosOperation;
import com.nepxion.discovery.common.util.PropertiesUtil;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class NacosAutoConfiguration {
    @Autowired
    private Environment environment;

    @Bean
    @ConditionalOnMissingBean
    public ConfigService nacosConfigService() throws NacosException {
        Properties properties = NacosAutoConfiguration.createNacosProperties(this.environment, true);
        return NacosFactory.createConfigService((Properties)properties);
    }

    @Bean
    public NacosOperation nacosOperation() {
        return new NacosOperation();
    }

    public static Properties createNacosProperties(Environment environment, boolean enableRemoteSyncConfig) {
        Properties properties = new Properties();
        PropertiesUtil.enrichProperties((Properties)properties, (Environment)environment, (String)"spring.cloud.nacos.config", (boolean)true, (boolean)true);
        PropertiesUtil.enrichProperties((Properties)properties, (Environment)environment, (String)"nacos", (boolean)true, (boolean)true);
        properties.put("enableRemoteSyncConfig", Boolean.toString(enableRemoteSyncConfig));
        return properties;
    }
}

