/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.nacos.operation;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.nepxion.discovery.common.entity.FormatType;
import com.nepxion.discovery.common.nacos.operation.NacosSubscribeCallback;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class NacosOperation
implements DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(NacosOperation.class);
    @Autowired
    private ConfigService nacosConfigService;
    @Autowired
    private Environment environment;

    public String getConfig(String group, String serviceId) throws NacosException {
        String timeout = this.environment.getProperty("nacos.timout");
        if (StringUtils.isEmpty((CharSequence)timeout)) {
            timeout = this.environment.getProperty("spring.cloud.nacos.config.timout");
        }
        return this.nacosConfigService.getConfig(serviceId, group, StringUtils.isNotEmpty((CharSequence)timeout) ? Long.valueOf(timeout) : 30000L);
    }

    public boolean removeConfig(String group, String serviceId) throws NacosException {
        return this.nacosConfigService.removeConfig(serviceId, group);
    }

    public boolean publishConfig(String group, String serviceId, String config) throws NacosException {
        return this.nacosConfigService.publishConfig(serviceId, group, config);
    }

    public boolean publishConfig(String group, String serviceId, String config, FormatType formatType) throws NacosException {
        return this.nacosConfigService.publishConfig(serviceId, group, config, formatType.toString());
    }

    public Listener subscribeConfig(String group, String serviceId, final Executor executor, final NacosSubscribeCallback nacosSubscribeCallback) throws NacosException {
        Listener listener = new Listener(){

            public void receiveConfigInfo(String config) {
                nacosSubscribeCallback.callback(config);
            }

            public Executor getExecutor() {
                return executor;
            }
        };
        this.nacosConfigService.addListener(serviceId, group, listener);
        return listener;
    }

    public void unsubscribeConfig(String group, String serviceId, Listener listener) {
        this.nacosConfigService.removeListener(serviceId, group, listener);
    }

    public void destroy() throws Exception {
        this.nacosConfigService.shutDown();
        LOG.info("Shutting down Nacos config service...");
    }
}

