/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.nacos.proccessor;

import com.alibaba.nacos.api.config.listener.Listener;
import com.nepxion.discovery.common.entity.ConfigType;
import com.nepxion.discovery.common.nacos.operation.NacosOperation;
import com.nepxion.discovery.common.nacos.operation.NacosSubscribeCallback;
import com.nepxion.discovery.common.processor.DiscoveryConfigProcessor;
import com.nepxion.discovery.common.thread.DiscoveryThreadPoolFactory;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class NacosProcessor
extends DiscoveryConfigProcessor {
    private ExecutorService executorService = DiscoveryThreadPoolFactory.getExecutorService((String)"nacos-config");
    @Autowired
    private NacosOperation nacosOperation;
    private Listener listener;

    @PostConstruct
    public void initialize() {
        this.beforeInitialization();
        String group = this.getGroup();
        String dataId = this.getDataId();
        this.logSubscribeStarted();
        try {
            this.listener = this.nacosOperation.subscribeConfig(group, dataId, this.executorService, new NacosSubscribeCallback(){

                @Override
                public void callback(String config) {
                    try {
                        NacosProcessor.this.callbackConfig(config);
                    }
                    catch (Exception e) {
                        NacosProcessor.this.logCallbackFailed(e);
                    }
                }
            });
        }
        catch (Exception e) {
            this.logSubscribeFailed(e);
        }
        this.logGetStarted();
        try {
            String config = this.nacosOperation.getConfig(group, dataId);
            if (config != null) {
                this.callbackConfig(config);
            } else {
                this.logNotFound();
            }
        }
        catch (Exception e) {
            this.logGetFailed(e);
        }
        this.afterInitialization();
    }

    public void destroy() {
        if (this.listener == null) {
            return;
        }
        String group = this.getGroup();
        String dataId = this.getDataId();
        this.logUnsubscribeStarted();
        try {
            this.nacosOperation.unsubscribeConfig(group, dataId, this.listener);
        }
        catch (Exception e) {
            this.logUnsubscribeFailed(e);
        }
        this.executorService.shutdownNow();
    }

    public ConfigType getConfigType() {
        return ConfigType.NACOS;
    }
}

