/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.entity;

public enum ConfigType {
    NACOS("Nacos"),
    APOLLO("Apollo"),
    REDIS("Redis"),
    ZOOKEEPER("Zookeeper"),
    CONSUL("Consul"),
    ETCD("Etcd");

    public static final ConfigType[] SINGLE_KEY_CONFIG_TYPES;
    public static final ConfigType[] MULTI_KEY_CONFIG_TYPES;
    private String value;

    private ConfigType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static ConfigType[] getSingleKeyConfigTypes() {
        return SINGLE_KEY_CONFIG_TYPES;
    }

    public static ConfigType[] getMultiKeyConfigTypes() {
        return MULTI_KEY_CONFIG_TYPES;
    }

    public static boolean isSingleKey(ConfigType configType) {
        for (int i = 0; i < SINGLE_KEY_CONFIG_TYPES.length; ++i) {
            ConfigType type = SINGLE_KEY_CONFIG_TYPES[i];
            if (type != configType) continue;
            return true;
        }
        return false;
    }

    public static ConfigType fromString(String value) {
        for (ConfigType type : ConfigType.values()) {
            if (!type.getValue().equalsIgnoreCase(value)) continue;
            return type;
        }
        throw new IllegalArgumentException("No matched type with value=" + value);
    }

    public String toString() {
        return this.value;
    }

    static {
        SINGLE_KEY_CONFIG_TYPES = new ConfigType[]{APOLLO, CONSUL, ETCD};
        MULTI_KEY_CONFIG_TYPES = new ConfigType[]{NACOS, REDIS, ZOOKEEPER};
    }
}

