/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.TypeComparator;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class DiscoveryExpressionResolver {
    public static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    public static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\#H\\['\\S+'\\]");
    public static final Pattern EXPRESSION_SINGLE_QUOTES_PATTERN = Pattern.compile("[^\\S\"']+|\"[^\"]*\"|'[^']*'");

    public static boolean eval(String expression, String key, Map<String, String> map, TypeComparator typeComparator) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setTypeComparator(typeComparator);
        if (map != null) {
            context.setVariable(key, map);
        } else {
            context.setVariable(key, new HashMap());
        }
        return DiscoveryExpressionResolver.eval(expression, context);
    }

    public static boolean eval(String expression, StandardEvaluationContext context) {
        try {
            Boolean result = (Boolean)EXPRESSION_PARSER.parseExpression(expression).getValue((EvaluationContext)context, Boolean.class);
            return result != null ? result : false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<String> extractList(String expression) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher matcher = EXPRESSION_PATTERN.matcher(expression);
        while (matcher.find()) {
            String group = matcher.group();
            String name = StringUtils.substringBetween((String)group, (String)"#H['", (String)"']").trim();
            list.add(name);
        }
        return list;
    }

    public static Map<String, String> extractMap(String expression) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Matcher matcher = EXPRESSION_SINGLE_QUOTES_PATTERN.matcher(expression);
        int index = 0;
        String key = null;
        while (matcher.find()) {
            String group = matcher.group();
            if (!group.startsWith("'") || !group.endsWith("'")) continue;
            String name = StringUtils.substringBetween((String)group, (String)"'", (String)"'").trim();
            if (index % 2 == 0) {
                key = name;
            } else if (index % 2 == 1) {
                map.put(key, name);
            }
            ++index;
        }
        return map;
    }
}

