/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.util;

import com.nepxion.discovery.common.util.StringUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PluginInfoUtil {
    private static Pattern pattern = Pattern.compile("\\[\\S+\\]");

    public static List<Map<String, String>> assembleAll(String text, String filters) {
        List<String> filterList = StringUtil.splitToList(filters, ",");
        return PluginInfoUtil.assembleAll(text, filterList);
    }

    public static List<Map<String, String>> assembleAll(String text, List<String> filterList) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        List<String> singleList = StringUtil.splitToList(text, " -> ");
        for (String value : singleList) {
            Map<String, String> map = PluginInfoUtil.assembleSingle(value, filterList);
            list.add(map);
        }
        return list;
    }

    public static Map<String, String> assembleSingle(String text, String filters) {
        List<String> filterList = StringUtil.splitToList(filters, ",");
        return PluginInfoUtil.assembleSingle(text, filterList);
    }

    public static Map<String, String> assembleSingle(String text, List<String> filterList) {
        text = StringUtils.replace((String)text, (String)"][", (String)"] [");
        Matcher matcher = pattern.matcher(text);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            String group = matcher.group();
            String value = StringUtils.substringBetween((String)group, (String)"[", (String)"]");
            String[] array = StringUtils.split((String)value, (String)"=");
            if (!CollectionUtils.isEmpty(filterList) && !filterList.contains(array[0])) continue;
            map.put(array[0], array[1]);
        }
        return map;
    }

    public static String extractAll(String text, String filters) {
        List<String> filterList = StringUtil.splitToList(filters, ",");
        return PluginInfoUtil.extractAll(text, filterList);
    }

    public static String extractAll(String text, List<String> filterList) {
        if (CollectionUtils.isEmpty(filterList)) {
            return text;
        }
        StringBuilder stringBuilder = new StringBuilder();
        List<Map<String, String>> list = PluginInfoUtil.assembleAll(text, filterList);
        for (Map<String, String> map : list) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                stringBuilder.append("[").append(key).append("=").append(value).append("]");
            }
            stringBuilder.append(" -> ");
        }
        stringBuilder.delete(stringBuilder.length() - 4, stringBuilder.length());
        return stringBuilder.toString();
    }

    public static String substringSingle(String text, String keyword) {
        if (text.contains("[" + keyword + "=")) {
            String value = text.substring(text.indexOf("[" + keyword + "=") + keyword.length() + 2);
            return value.substring(0, value.indexOf("]"));
        }
        return null;
    }
}

