/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.util;

import com.alibaba.spring.util.PropertySourcesUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class PropertiesUtil {
    public static final Pattern PATTERN = Pattern.compile("-(\\w)");

    public static void enrichProperties(Properties properties, Environment environment, String prefix, boolean replaceExistedKey, boolean ignoreEmptyValue) {
        PropertiesUtil.enrichProperties(properties, environment, PATTERN, prefix, replaceExistedKey, ignoreEmptyValue);
    }

    public static void enrichProperties(Properties properties, Environment environment, Pattern pattern, String prefix, boolean replaceExistedKey, boolean ignoreEmptyValue) {
        Map map = PropertySourcesUtils.getSubProperties((ConfigurableEnvironment)((ConfigurableEnvironment)environment), (String)prefix);
        for (Map.Entry entry : map.entrySet()) {
            String key = PropertiesUtil.resolveKey(pattern, (String)entry.getKey());
            String value = String.valueOf(entry.getValue());
            PropertiesUtil.addProperty(properties, key, value, replaceExistedKey, ignoreEmptyValue);
        }
    }

    public static void addProperty(Properties properties, String key, String value, boolean replaceExistedKey, boolean ignoreEmptyValue) {
        if (properties.containsKey(key)) {
            if (replaceExistedKey) {
                PropertiesUtil.addProperty(properties, key, value, ignoreEmptyValue);
            }
        } else {
            PropertiesUtil.addProperty(properties, key, value, ignoreEmptyValue);
        }
    }

    public static void addProperty(Properties properties, String key, String value, boolean ignoreEmptyValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            if (!ignoreEmptyValue) {
                properties.put(key, value);
            }
        } else {
            properties.put(key, value);
        }
    }

    public static String resolveKey(String key) {
        return PropertiesUtil.resolveKey(PATTERN, key);
    }

    public static String resolveKey(Pattern pattern, String key) {
        Matcher matcher = pattern.matcher(key);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPropertiesFormat(String properties) {
        boolean bl;
        InputStream inputStream;
        block9: {
            if (StringUtils.isBlank((CharSequence)properties)) {
                return false;
            }
            inputStream = null;
            InputStreamReader reader = null;
            try {
                inputStream = IOUtils.toInputStream((String)properties, (String)"UTF-8");
                reader = new InputStreamReader(inputStream, "UTF-8");
                new Properties().load(reader);
                bl = true;
                if (reader == null) break block9;
            }
            catch (Exception e) {
                boolean bl2 = false;
                return bl2;
            }
            finally {
                if (reader != null) {
                    IOUtils.closeQuietly(reader);
                }
                if (inputStream != null) {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        if (inputStream != null) {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return bl;
    }
}

