/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.util;

import com.nepxion.discovery.common.util.JsonUtil;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    public static List<String> splitToList(String value) {
        return StringUtil.splitToList(value, ";");
    }

    public static List<String> splitToList(String value, String separate) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        String[] valueArray = StringUtils.splitByWholeSeparator((String)value, (String)separate);
        return Arrays.asList(valueArray);
    }

    public static String convertToString(List<String> list) {
        return StringUtil.convertToString(list, ";");
    }

    public static String convertToString(List<String> list, String separate) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            String value = list.get(i);
            stringBuilder.append(value);
            if (i >= list.size() - 1) continue;
            stringBuilder.append(separate);
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> splitToMap(String value) {
        return StringUtil.splitToMap(value, "=", ";");
    }

    public static Map<String, String> splitToMap(String value, String equals, String separate) {
        String[] separateArray;
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String separateValue : separateArray = StringUtils.splitByWholeSeparator((String)value, (String)separate)) {
            String[] equalsArray = StringUtils.splitByWholeSeparator((String)separateValue, (String)equals);
            map.put(equalsArray[0].trim(), equalsArray[1].trim());
        }
        return map;
    }

    public static Map<String, List<String>> splitToComplexMap(String value) {
        return StringUtil.splitToComplexMap(value, ";");
    }

    public static Map<String, List<String>> splitToComplexMap(String value, String separate) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        try {
            Map jsonMap = JsonUtil.fromJson(value, Map.class);
            for (Map.Entry entry : jsonMap.entrySet()) {
                String key = (String)entry.getKey();
                String list = (String)entry.getValue();
                map.put(key, StringUtil.splitToList(list, separate));
            }
        }
        catch (Exception e) {
            List<String> valueList = StringUtil.splitToList(value, separate);
            map.put("undefined", valueList);
        }
        return map;
    }

    public static String convertToString(Map<String, ?> map) {
        return StringUtil.convertToString(map, "=", ";");
    }

    public static String convertToString(Map<String, ?> map, String equals, String separate) {
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int index = 0;
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            stringBuilder.append(key + equals + value);
            if (index < map.size() - 1) {
                stringBuilder.append(separate);
            }
            ++index;
        }
        return stringBuilder.toString();
    }

    public static String convertToComplexString(Map<String, List<String>> map) {
        return StringUtil.convertToComplexString(map, ";");
    }

    public static String convertToComplexString(Map<String, List<String>> map, String separate) {
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        if (map.size() == 1 && map.containsKey("undefined")) {
            List<String> value = map.get("undefined");
            return StringUtil.convertToString(value);
        }
        LinkedHashMap<String, String> jsonMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            jsonMap.put(key, StringUtil.convertToString(value));
        }
        return JsonUtil.toJson(jsonMap);
    }

    public static Map<String, String> convertToMap(List<String> list) {
        return StringUtil.convertToMap(list, "=");
    }

    public static Map<String, String> convertToMap(List<String> list, String separate) {
        if (list == null) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String value : list) {
            String[] valueArray = StringUtils.splitByWholeSeparator((String)value, (String)separate);
            map.put(valueArray[0], valueArray[1]);
        }
        return map;
    }

    public static String firstToUpperCase(String value) {
        return StringUtils.capitalize((String)value);
    }

    public static String firstToLowerCase(String value) {
        return StringUtils.uncapitalize((String)value);
    }

    public static String simulateText(String value, int size, String padValue) {
        return StringUtils.rightPad((String)value, (int)size, (String)padValue);
    }

    public static String simulateText(int size) {
        return StringUtil.simulateText("10", size, "10");
    }

    public static String toDisplaySize(String value) {
        return FileUtils.byteCountToDisplaySize((long)value.length());
    }

    public static int count(String text, String keyText) {
        if (StringUtils.isEmpty((CharSequence)text) || StringUtils.isEmpty((CharSequence)keyText)) {
            return -1;
        }
        int count = 0;
        while (text.indexOf(keyText) != -1) {
            text = text.substring(text.indexOf(keyText) + 1, text.length());
            ++count;
        }
        return count;
    }
}

