/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.util;

import com.nepxion.discovery.common.entity.InstanceEntity;
import com.nepxion.discovery.common.entity.VersionSortEntity;
import com.nepxion.discovery.common.entity.VersionSortType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class VersionSortUtil {
    public static List<String> assembleVersionList(List<InstanceEntity> instanceEntityList, VersionSortType versionSortType) {
        String defaultVersion;
        if (CollectionUtils.isEmpty(instanceEntityList)) {
            return null;
        }
        ArrayList<VersionSortEntity> versionSortEntityList = new ArrayList<VersionSortEntity>();
        for (InstanceEntity instanceEntity : instanceEntityList) {
            String version = instanceEntity.getVersion();
            String serviceUUId = instanceEntity.getServiceUUId();
            VersionSortEntity versionSortEntity = new VersionSortEntity();
            versionSortEntity.setVersion(version);
            versionSortEntity.setServiceUUId(serviceUUId);
            versionSortEntityList.add(versionSortEntity);
        }
        List<String> versionList = VersionSortUtil.getVersionList(versionSortEntityList, versionSortType);
        if (versionList.contains(defaultVersion = "default")) {
            versionList.remove(defaultVersion);
            versionList.add(0, defaultVersion);
        }
        return versionList;
    }

    public static List<String> getVersionList(List<VersionSortEntity> versionSortEntityList, final VersionSortType versionSortType) {
        ArrayList<String> versionList = new ArrayList<String>();
        Collections.sort(versionSortEntityList, new Comparator<VersionSortEntity>(){

            @Override
            public int compare(VersionSortEntity versionSortEntity1, VersionSortEntity versionSortEntity2) {
                if (versionSortType == VersionSortType.VERSION) {
                    String version1 = versionSortEntity1.getVersion();
                    String version2 = versionSortEntity2.getVersion();
                    return version1.compareTo(version2);
                }
                String serviceUUId1 = versionSortEntity1.getServiceUUId();
                String serviceUUId2 = versionSortEntity2.getServiceUUId();
                return serviceUUId1.compareTo(serviceUUId2);
            }
        });
        for (VersionSortEntity versionSortEntity : versionSortEntityList) {
            String version = versionSortEntity.getVersion();
            if (versionList.contains(version)) continue;
            versionList.add(version);
        }
        return versionList;
    }
}

