/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.util;

import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class YamlUtil {
    private static DumperOptions dumperOptions = new DumperOptions();

    public static boolean isYamlFormat(String yaml) {
        if (StringUtils.isBlank((CharSequence)yaml)) {
            return false;
        }
        Yaml snakeYaml = new Yaml();
        try {
            snakeYaml.load(yaml);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T> String toYaml(T object) {
        Yaml snakeYaml = new Yaml(dumperOptions);
        return snakeYaml.dump(object);
    }

    public static <T> T fromYaml(String yaml, Class<T> clazz) {
        Yaml snakeYaml = new Yaml();
        return (T)snakeYaml.loadAs(yaml, clazz);
    }

    public static boolean isYamlFormat(SafeConstructor safeConstructor, String yaml) {
        if (StringUtils.isBlank((CharSequence)yaml)) {
            return false;
        }
        Yaml snakeYaml = new Yaml((BaseConstructor)safeConstructor);
        try {
            snakeYaml.load(yaml);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T> String toYaml(SafeConstructor safeConstructor, T object) {
        Yaml snakeYaml = new Yaml((BaseConstructor)safeConstructor, new Representer(), dumperOptions);
        return snakeYaml.dump(object);
    }

    public static <T> T fromYaml(SafeConstructor safeConstructor, String yaml, Class<T> clazz) {
        Yaml snakeYaml = new Yaml((BaseConstructor)safeConstructor);
        return (T)snakeYaml.loadAs(yaml, clazz);
    }

    static {
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
    }
}

