/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.yaml;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.Assert;
import org.yaml.snakeyaml.constructor.Constructor;

public class YamlSafeConstructor
extends Constructor {
    private Set<String> supportedTypes;

    public YamlSafeConstructor(Set<Class<?>> supportedClasses) {
        this.supportedTypes = supportedClasses.stream().map(Class::getName).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    protected Class<?> getClassForName(String name) throws ClassNotFoundException {
        Assert.state((boolean)this.supportedTypes.contains(name), (String)("Unsupported '" + name + "' type encountered in YAML document"));
        return super.getClassForName(name);
    }
}

