/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.configcenter.adapter;

import com.nepxion.discovery.common.entity.ConfigType;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.SubscriptionType;
import com.nepxion.discovery.plugin.configcenter.loader.RemoteConfigLoader;
import com.nepxion.discovery.plugin.configcenter.logger.ConfigLogger;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.adapter.PluginConfigAdapter;
import com.nepxion.discovery.plugin.framework.event.PluginEventWapper;
import com.nepxion.discovery.plugin.framework.event.RuleClearedEvent;
import com.nepxion.discovery.plugin.framework.event.RuleUpdatedEvent;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ConfigAdapter
extends RemoteConfigLoader
implements PluginConfigAdapter {
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired
    private PluginEventWapper pluginEventWapper;
    @Autowired
    private ConfigLogger configLogger;

    @Override
    public String[] getConfigList() throws Exception {
        String[] configList = new String[]{this.getConfig(false), this.getConfig(true)};
        return configList;
    }

    public String getConfig(boolean globalConfig) throws Exception {
        this.logGetStarted(globalConfig);
        String group = this.getGroup();
        String dataId = this.getDataId(globalConfig);
        String config = this.getConfig(group, dataId);
        if (StringUtils.isNotBlank((CharSequence)config)) {
            this.logFound(globalConfig);
        } else {
            this.logNotFound(globalConfig);
        }
        return config;
    }

    public void callbackConfig(String config, boolean globalConfig) {
        SubscriptionType subscriptionType = this.getSubscriptionType(globalConfig);
        if (StringUtils.isNotBlank((CharSequence)config)) {
            this.logUpdatedEvent(globalConfig);
            RuleEntity ruleEntity = null;
            ruleEntity = globalConfig ? this.pluginAdapter.getDynamicGlobalRule() : this.pluginAdapter.getDynamicPartialRule();
            String rule = null;
            if (ruleEntity != null) {
                rule = ruleEntity.getContent();
            }
            if (!StringUtils.equals((CharSequence)rule, (CharSequence)config)) {
                this.fireRuleUpdated(new RuleUpdatedEvent(subscriptionType, config), true);
            } else {
                this.logUpdatedSame(globalConfig);
            }
        } else {
            this.logClearedEvent(globalConfig);
            this.fireRuleCleared(new RuleClearedEvent(subscriptionType), true);
        }
    }

    public String getGroup() {
        return this.pluginAdapter.getGroup();
    }

    public String getServiceId() {
        return this.pluginAdapter.getServiceId();
    }

    public String getDataId(boolean globalConfig) {
        String group = this.getGroup();
        String serviceId = this.getServiceId();
        return globalConfig ? group : serviceId;
    }

    public void fireRuleUpdated(RuleUpdatedEvent ruleUpdatedEvent, boolean async) {
        this.pluginEventWapper.fireRuleUpdated(ruleUpdatedEvent, async);
    }

    public void fireRuleCleared(RuleClearedEvent ruleClearedEvent, boolean async) {
        this.pluginEventWapper.fireRuleCleared(ruleClearedEvent, async);
    }

    public SubscriptionType getSubscriptionType(boolean globalConfig) {
        return globalConfig ? SubscriptionType.GLOBAL : SubscriptionType.PARTIAL;
    }

    public void logGetStarted(boolean globalConfig) {
        this.configLogger.logGetStarted(globalConfig);
    }

    public void logSubscribeStarted(boolean globalConfig) {
        this.configLogger.logSubscribeStarted(globalConfig);
    }

    public void logSubscribeFailed(Exception e, boolean globalConfig) {
        this.configLogger.logSubscribeFailed(e, globalConfig);
    }

    public void logUnsubscribeStarted(boolean globalConfig) {
        this.configLogger.logUnsubscribeStarted(globalConfig);
    }

    public void logUnsubscribeFailed(Exception e, boolean globalConfig) {
        this.configLogger.logUnsubscribeFailed(e, globalConfig);
    }

    public void logFound(boolean globalConfig) {
        this.configLogger.logFound(globalConfig);
    }

    public void logNotFound(boolean globalConfig) {
        this.configLogger.logNotFound(globalConfig);
    }

    public void logUpdatedEvent(boolean globalConfig) {
        this.configLogger.logUpdatedEvent(globalConfig);
    }

    public void logClearedEvent(boolean globalConfig) {
        this.configLogger.logClearedEvent(globalConfig);
    }

    public void logUpdatedSame(boolean globalConfig) {
        this.configLogger.logUpdatedSame(globalConfig);
    }

    public boolean isConfigSingleKey() {
        ConfigType configType = this.getConfigType();
        return ConfigType.isSingleKey((ConfigType)configType);
    }

    public abstract String getConfig(String var1, String var2) throws Exception;
}

