/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.configcenter.initializer;

import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.SubscriptionType;
import com.nepxion.discovery.plugin.configcenter.loader.LocalConfigLoader;
import com.nepxion.discovery.plugin.configcenter.loader.RemoteConfigLoader;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.event.PluginEventWapper;
import com.nepxion.discovery.plugin.framework.event.RuleFailureEvent;
import com.nepxion.discovery.plugin.framework.parser.PluginConfigParser;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class ConfigInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigInitializer.class);
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired
    private PluginConfigParser pluginConfigParser;
    @Autowired
    private PluginEventWapper pluginEventWapper;
    @Autowired
    private LocalConfigLoader localConfigLoader;
    @Autowired(required=false)
    private RemoteConfigLoader remoteConfigLoader;
    @Value(value="${spring.application.parameter.event.onstart.enabled:true}")
    private Boolean parameterEventOnstartEnabled;

    @PostConstruct
    public void initialize() {
        String localConfig;
        String[] localConfigList;
        RuleEntity ruleEntity;
        LOG.info("------------- Load Discovery Config --------------");
        String[] remoteConfigList = this.getRemoteConfigList();
        if (remoteConfigList != null) {
            String globalRemoteConfig;
            String partialRemoteConfig = remoteConfigList[0];
            if (StringUtils.isNotEmpty((CharSequence)partialRemoteConfig)) {
                LOG.info("Initialize partial remote config...");
                try {
                    RuleEntity ruleEntity2 = this.pluginConfigParser.parse(partialRemoteConfig);
                    this.pluginAdapter.setDynamicPartialRule(ruleEntity2);
                }
                catch (Exception e) {
                    LOG.error("Initialize partial remote config failed", (Throwable)e);
                    this.pluginEventWapper.fireRuleFailure(new RuleFailureEvent(SubscriptionType.PARTIAL, partialRemoteConfig, e));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(globalRemoteConfig = remoteConfigList[1]))) {
                LOG.info("Initialize global remote config...");
                try {
                    ruleEntity = this.pluginConfigParser.parse(globalRemoteConfig);
                    this.pluginAdapter.setDynamicGlobalRule(ruleEntity);
                }
                catch (Exception e) {
                    LOG.error("Initialize global remote config failed", (Throwable)e);
                    this.pluginEventWapper.fireRuleFailure(new RuleFailureEvent(SubscriptionType.GLOBAL, globalRemoteConfig, e));
                }
            }
        }
        if ((localConfigList = this.getLocalConfigList()) != null && StringUtils.isNotEmpty((CharSequence)(localConfig = localConfigList[0]))) {
            LOG.info("Initialize local config...");
            try {
                ruleEntity = this.pluginConfigParser.parse(localConfig);
                this.pluginAdapter.setLocalRule(ruleEntity);
            }
            catch (Exception e) {
                LOG.error("Initialize local config failed", (Throwable)e);
            }
        }
        if (remoteConfigList == null && localConfigList == null) {
            LOG.info("No configs are found");
        }
        if (this.parameterEventOnstartEnabled.booleanValue()) {
            this.pluginEventWapper.fireParameterChanged();
        }
        LOG.info("--------------------------------------------------");
    }

    private String[] getRemoteConfigList() {
        if (this.remoteConfigLoader != null) {
            String[] configList = null;
            try {
                configList = this.remoteConfigLoader.getConfigList();
            }
            catch (Exception e) {
                LOG.warn("Get remote config list failed", (Throwable)e);
            }
            return configList;
        }
        LOG.info("Remote config loader isn't provided");
        return null;
    }

    private String[] getLocalConfigList() {
        String[] configList = null;
        try {
            configList = this.localConfigLoader.getConfigList();
        }
        catch (Exception e) {
            LOG.warn("Get local config list failed", (Throwable)e);
        }
        return configList;
    }
}

