/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.configcenter.parser.xml;

import com.nepxion.discovery.common.entity.CountFilterEntity;
import com.nepxion.discovery.common.entity.CustomizationEntity;
import com.nepxion.discovery.common.entity.DiscoveryEntity;
import com.nepxion.discovery.common.entity.FilterHolderEntity;
import com.nepxion.discovery.common.entity.FilterType;
import com.nepxion.discovery.common.entity.HostFilterEntity;
import com.nepxion.discovery.common.entity.RegionWeightEntity;
import com.nepxion.discovery.common.entity.RegisterEntity;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.VersionEntity;
import com.nepxion.discovery.common.entity.VersionFilterEntity;
import com.nepxion.discovery.common.entity.WeightEntity;
import com.nepxion.discovery.common.entity.WeightFilterEntity;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.common.util.StringUtil;
import com.nepxion.discovery.plugin.configcenter.parser.xml.dom4j.Dom4JReader;
import com.nepxion.discovery.plugin.framework.config.PluginConfigParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlConfigParser
implements PluginConfigParser {
    private static final Logger LOG = LoggerFactory.getLogger(XmlConfigParser.class);

    public RuleEntity parse(String config) {
        if (StringUtils.isEmpty((CharSequence)config)) {
            throw new DiscoveryException("Config is null or empty");
        }
        try {
            Document document = Dom4JReader.getDocument(config);
            Element rootElement = document.getRootElement();
            return this.parseRoot(config, rootElement);
        }
        catch (Exception e) {
            throw new DiscoveryException(e.getMessage(), (Throwable)e);
        }
    }

    private RuleEntity parseRoot(String config, Element element) {
        LOG.info("Start to parse rule xml...");
        int registerElementCount = element.elements("register").size();
        if (registerElementCount > 1) {
            throw new DiscoveryException("Allow only one element[register] to be configed");
        }
        int discoveryElementCount = element.elements("discovery").size();
        if (discoveryElementCount > 1) {
            throw new DiscoveryException("Allow only one element[discovery] to be configed");
        }
        int customizationElementCount = element.elements("customization").size();
        if (customizationElementCount > 1) {
            throw new DiscoveryException("Allow only one element[customization] to be configed");
        }
        RegisterEntity registerEntity = null;
        DiscoveryEntity discoveryEntity = null;
        CustomizationEntity customizationEntity = null;
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Object childElementObject = elementIterator.next();
            if (!(childElementObject instanceof Element)) continue;
            Element childElement = (Element)childElementObject;
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"register")) {
                registerEntity = new RegisterEntity();
                this.parseRegister(childElement, registerEntity);
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"discovery")) {
                discoveryEntity = new DiscoveryEntity();
                this.parseDiscovery(childElement, discoveryEntity);
                continue;
            }
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"customization")) continue;
            customizationEntity = new CustomizationEntity();
            this.parseCustomization(childElement, customizationEntity);
        }
        RuleEntity ruleEntity = new RuleEntity();
        ruleEntity.setRegisterEntity(registerEntity);
        ruleEntity.setDiscoveryEntity(discoveryEntity);
        ruleEntity.setCustomizationEntity(customizationEntity);
        ruleEntity.setContent(config);
        LOG.info("Rule entity=\n{}", (Object)ruleEntity);
        return ruleEntity;
    }

    private void parseRegister(Element element, RegisterEntity registerEntity) {
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Object childElementObject = elementIterator.next();
            if (!(childElementObject instanceof Element)) continue;
            Element childElement = (Element)childElementObject;
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"blacklist")) {
                this.parseHostFilter(childElement, "blacklist", (FilterHolderEntity)registerEntity);
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"whitelist")) {
                this.parseHostFilter(childElement, "whitelist", (FilterHolderEntity)registerEntity);
                continue;
            }
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"count")) continue;
            this.parseCountFilter(childElement, registerEntity);
        }
    }

    private void parseDiscovery(Element element, DiscoveryEntity discoveryEntity) {
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Object childElementObject = elementIterator.next();
            if (!(childElementObject instanceof Element)) continue;
            Element childElement = (Element)childElementObject;
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"blacklist")) {
                this.parseHostFilter(childElement, "blacklist", (FilterHolderEntity)discoveryEntity);
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"whitelist")) {
                this.parseHostFilter(childElement, "whitelist", (FilterHolderEntity)discoveryEntity);
                continue;
            }
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"version")) {
                this.parseVersionFilter(childElement, discoveryEntity);
                continue;
            }
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"weight")) continue;
            this.parseWeightFilter(childElement, discoveryEntity);
        }
    }

    private void parseCustomization(Element element, CustomizationEntity customizationEntity) {
        Map customizationMap = customizationEntity.getCustomizationMap();
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Element childElement;
            Object childElementObject = elementIterator.next();
            if (!(childElementObject instanceof Element) || !StringUtils.equals((CharSequence)(childElement = (Element)childElementObject).getName(), (CharSequence)"service")) continue;
            Attribute serviceNameAttribute = childElement.attribute("service-name");
            if (serviceNameAttribute == null) {
                throw new DiscoveryException("Attribute[service-name] in element[" + childElement.getName() + "] is missing");
            }
            String serviceName = serviceNameAttribute.getData().toString().trim();
            Attribute keyAttribute = childElement.attribute("key");
            if (keyAttribute == null) {
                throw new DiscoveryException("Attribute[key] in element[" + childElement.getName() + "] is missing");
            }
            String key = keyAttribute.getData().toString().trim();
            Attribute valueAttribute = childElement.attribute("value");
            if (valueAttribute == null) {
                throw new DiscoveryException("Attribute[value] in element[" + childElement.getName() + "] is missing");
            }
            String value = valueAttribute.getData().toString().trim();
            LinkedHashMap<String, String> customizationParameter = (LinkedHashMap<String, String>)customizationMap.get(serviceName);
            if (customizationParameter == null) {
                customizationParameter = new LinkedHashMap<String, String>();
                customizationMap.put(serviceName, customizationParameter);
            }
            customizationParameter.put(key, value);
        }
    }

    private void parseHostFilter(Element element, String filterTypeValue, FilterHolderEntity filterHolderEntity) {
        HostFilterEntity hostFilterEntity = filterHolderEntity.getHostFilterEntity();
        if (hostFilterEntity != null) {
            throw new DiscoveryException("Allow only one filter element to be configed, [blacklist] or [whitelist]");
        }
        hostFilterEntity = new HostFilterEntity();
        hostFilterEntity.setFilterType(FilterType.fromString((String)filterTypeValue));
        Attribute globalFilterAttribute = element.attribute("filter-value");
        if (globalFilterAttribute != null) {
            String globalFilterValue = globalFilterAttribute.getData().toString().trim();
            List globalFilterValueList = StringUtil.splitToList((String)globalFilterValue, (String)";");
            hostFilterEntity.setFilterValueList(globalFilterValueList);
        }
        Map filterMap = hostFilterEntity.getFilterMap();
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Element childElement;
            Object childElementObject = elementIterator.next();
            if (!(childElementObject instanceof Element) || !StringUtils.equals((CharSequence)(childElement = (Element)childElementObject).getName(), (CharSequence)"service")) continue;
            Attribute serviceNameAttribute = childElement.attribute("service-name");
            if (serviceNameAttribute == null) {
                throw new DiscoveryException("Attribute[service-name] in element[" + childElement.getName() + "] is missing");
            }
            String serviceName = serviceNameAttribute.getData().toString().trim();
            Attribute filterValueAttribute = childElement.attribute("filter-value");
            List filterValueList = null;
            if (filterValueAttribute != null) {
                String filterValue = filterValueAttribute.getData().toString().trim();
                filterValueList = StringUtil.splitToList((String)filterValue, (String)";");
            }
            filterMap.put(serviceName, filterValueList);
        }
        filterHolderEntity.setHostFilterEntity(hostFilterEntity);
    }

    private void parseCountFilter(Element element, RegisterEntity registerEntity) {
        String globalFilterValue;
        CountFilterEntity countFilterEntity = registerEntity.getCountFilterEntity();
        if (countFilterEntity != null) {
            throw new DiscoveryException("Allow only one element[count] to be configed");
        }
        countFilterEntity = new CountFilterEntity();
        Attribute globalFilterAttribute = element.attribute("filter-value");
        if (globalFilterAttribute != null && StringUtils.isNotEmpty((CharSequence)(globalFilterValue = globalFilterAttribute.getData().toString().trim()))) {
            Integer globalValue = null;
            try {
                globalValue = Integer.valueOf(globalFilterValue);
            }
            catch (NumberFormatException e) {
                throw new DiscoveryException("Attribute[filter-value] value in element[" + element.getName() + "] is invalid, must be int type", (Throwable)e);
            }
            countFilterEntity.setFilterValue(globalValue);
        }
        Map filterMap = countFilterEntity.getFilterMap();
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            String filterValue;
            Element childElement;
            Object childElementObject = elementIterator.next();
            if (!(childElementObject instanceof Element) || !StringUtils.equals((CharSequence)(childElement = (Element)childElementObject).getName(), (CharSequence)"service")) continue;
            Attribute serviceNameAttribute = childElement.attribute("service-name");
            if (serviceNameAttribute == null) {
                throw new DiscoveryException("Attribute[service-name] in element[" + childElement.getName() + "] is missing");
            }
            String serviceName = serviceNameAttribute.getData().toString().trim();
            Integer value = null;
            Attribute filterValueAttribute = childElement.attribute("filter-value");
            if (filterValueAttribute != null && StringUtils.isNotEmpty((CharSequence)(filterValue = filterValueAttribute.getData().toString().trim()))) {
                try {
                    value = Integer.valueOf(filterValue);
                }
                catch (NumberFormatException e) {
                    throw new DiscoveryException("Attribute[filter-value] value in element[" + childElement.getName() + "] is invalid, must be int type", (Throwable)e);
                }
            }
            filterMap.put(serviceName, value);
        }
        registerEntity.setCountFilterEntity(countFilterEntity);
    }

    private void parseVersionFilter(Element element, DiscoveryEntity discoveryEntity) {
        VersionFilterEntity versionFilterEntity = discoveryEntity.getVersionFilterEntity();
        if (versionFilterEntity != null) {
            throw new DiscoveryException("Allow only one element[version] to be configed");
        }
        versionFilterEntity = new VersionFilterEntity();
        Map versionEntityMap = versionFilterEntity.getVersionEntityMap();
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            ArrayList<VersionEntity> versionEntityList;
            Attribute providerVersionValueAttribute;
            Element childElement;
            Object childElementObject = elementIterator.next();
            if (!(childElementObject instanceof Element) || !StringUtils.equals((CharSequence)(childElement = (Element)childElementObject).getName(), (CharSequence)"service")) continue;
            VersionEntity versionEntity = new VersionEntity();
            Attribute consumerServiceNameAttribute = childElement.attribute("consumer-service-name");
            if (consumerServiceNameAttribute == null) {
                throw new DiscoveryException("Attribute[consumer-service-name] in element[" + childElement.getName() + "] is missing");
            }
            String consumerServiceName = consumerServiceNameAttribute.getData().toString().trim();
            versionEntity.setConsumerServiceName(consumerServiceName);
            Attribute providerServiceNameAttribute = childElement.attribute("provider-service-name");
            if (providerServiceNameAttribute == null) {
                throw new DiscoveryException("Attribute[provider-service-name] in element[" + childElement.getName() + "] is missing");
            }
            String providerServiceName = providerServiceNameAttribute.getData().toString().trim();
            versionEntity.setProviderServiceName(providerServiceName);
            Attribute consumerVersionValueAttribute = childElement.attribute("consumer-version-value");
            if (consumerVersionValueAttribute != null) {
                String consumerVersionValue = consumerVersionValueAttribute.getData().toString().trim();
                List consumerVersionValueList = StringUtil.splitToList((String)consumerVersionValue, (String)";");
                versionEntity.setConsumerVersionValueList(consumerVersionValueList);
            }
            if ((providerVersionValueAttribute = childElement.attribute("provider-version-value")) != null) {
                String providerVersionValue = providerVersionValueAttribute.getData().toString().trim();
                List providerVersionValueList = StringUtil.splitToList((String)providerVersionValue, (String)";");
                versionEntity.setProviderVersionValueList(providerVersionValueList);
            }
            if ((versionEntityList = (ArrayList<VersionEntity>)versionEntityMap.get(consumerServiceName)) == null) {
                versionEntityList = new ArrayList<VersionEntity>();
                versionEntityMap.put(consumerServiceName, versionEntityList);
            }
            versionEntityList.add(versionEntity);
        }
        discoveryEntity.setVersionFilterEntity(versionFilterEntity);
    }

    private void parseWeightFilter(Element element, DiscoveryEntity discoveryEntity) {
        WeightFilterEntity weightFilterEntity = discoveryEntity.getWeightFilterEntity();
        if (weightFilterEntity != null) {
            throw new DiscoveryException("Allow only one element[weight] to be configed");
        }
        weightFilterEntity = new WeightFilterEntity();
        Map weightEntityMap = weightFilterEntity.getWeightEntityMap();
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Object childElementObject = elementIterator.next();
            if (!(childElementObject instanceof Element)) continue;
            Element childElement = (Element)childElementObject;
            if (StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"service")) {
                WeightEntity weightEntity = new WeightEntity();
                Attribute consumerServiceNameAttribute = childElement.attribute("consumer-service-name");
                String consumerServiceName = null;
                consumerServiceName = consumerServiceNameAttribute != null ? consumerServiceNameAttribute.getData().toString().trim() : "";
                weightEntity.setConsumerServiceName(consumerServiceName);
                Attribute providerServiceNameAttribute = childElement.attribute("provider-service-name");
                if (providerServiceNameAttribute == null) {
                    throw new DiscoveryException("Attribute[provider-service-name] in element[" + childElement.getName() + "] is missing");
                }
                String providerServiceName = providerServiceNameAttribute.getData().toString().trim();
                weightEntity.setProviderServiceName(providerServiceName);
                Attribute providerWeightValueAttribute = childElement.attribute("provider-weight-value");
                if (providerWeightValueAttribute == null) {
                    throw new DiscoveryException("Attribute[provider-weight-value] in element[" + childElement.getName() + "] is missing");
                }
                String providerWeightValue = providerWeightValueAttribute.getData().toString().trim();
                LinkedHashMap<String, Integer> weightMap = new LinkedHashMap<String, Integer>();
                List providerWeightValueList = StringUtil.splitToList((String)providerWeightValue, (String)";");
                for (String value : providerWeightValueList) {
                    String[] valueArray = StringUtils.split((String)value, (String)"=");
                    String version = valueArray[0].trim();
                    int weight = Integer.valueOf(valueArray[1].trim());
                    if (weight < 0) {
                        throw new DiscoveryException("Attribute[provider-weight-value] in element[" + childElement.getName() + "] has weight value less than 0");
                    }
                    weightMap.put(version, weight);
                }
                weightEntity.setWeightMap(weightMap);
                ArrayList<WeightEntity> weightEntityList = (ArrayList<WeightEntity>)weightEntityMap.get(consumerServiceName);
                if (weightEntityList == null) {
                    weightEntityList = new ArrayList<WeightEntity>();
                    weightEntityMap.put(consumerServiceName, weightEntityList);
                }
                weightEntityList.add(weightEntity);
                continue;
            }
            if (!StringUtils.equals((CharSequence)childElement.getName(), (CharSequence)"region")) continue;
            RegionWeightEntity regionWeightEntity = weightFilterEntity.getRegionWeightEntity();
            if (regionWeightEntity != null) {
                throw new DiscoveryException("Allow only one element[region] to be configed");
            }
            regionWeightEntity = new RegionWeightEntity();
            Attribute providerWeightValueAttribute = childElement.attribute("provider-weight-value");
            if (providerWeightValueAttribute == null) {
                throw new DiscoveryException("Attribute[provider-weight-value] in element[" + childElement.getName() + "] is missing");
            }
            String providerWeightValue = providerWeightValueAttribute.getData().toString().trim();
            LinkedHashMap<String, Integer> weightMap = new LinkedHashMap<String, Integer>();
            List providerWeightValueList = StringUtil.splitToList((String)providerWeightValue, (String)";");
            for (String value : providerWeightValueList) {
                String[] valueArray = StringUtils.split((String)value, (String)"=");
                String region = valueArray[0].trim();
                int weight = Integer.valueOf(valueArray[1].trim());
                if (weight < 0) {
                    throw new DiscoveryException("Attribute[provider-weight-value] in element[" + childElement.getName() + "] has weight value less than 0");
                }
                weightMap.put(region, weight);
            }
            regionWeightEntity.setWeightMap(weightMap);
            weightFilterEntity.setRegionWeightEntity(regionWeightEntity);
        }
        discoveryEntity.setWeightFilterEntity(weightFilterEntity);
    }
}

