/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.configuration;

import com.nepxion.discovery.common.entity.ConfigFormatType;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.plugin.framework.parser.PluginConfigDeparser;
import com.nepxion.discovery.plugin.framework.parser.PluginConfigParser;
import com.nepxion.discovery.plugin.framework.parser.json.JsonConfigDeparser;
import com.nepxion.discovery.plugin.framework.parser.json.JsonConfigParser;
import com.nepxion.discovery.plugin.framework.parser.xml.XmlConfigDeparser;
import com.nepxion.discovery.plugin.framework.parser.xml.XmlConfigParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class PluginParserAutoConfiguration {
    @Autowired
    private Environment environment;

    @Bean
    public PluginConfigParser pluginConfigParser() {
        String configFormat = (String)this.environment.getProperty("spring.application.config.format", String.class, (Object)"xml");
        ConfigFormatType configFormatType = ConfigFormatType.fromString((String)configFormat);
        switch (configFormatType) {
            case XML_FORMAT: {
                return new XmlConfigParser();
            }
            case JSON_FORMAT: {
                return new JsonConfigParser();
            }
        }
        throw new DiscoveryException("Invalid config format for '" + configFormat + "'");
    }

    @Bean
    public PluginConfigDeparser pluginDeconfigParser() {
        String configFormat = (String)this.environment.getProperty("spring.application.config.format", String.class, (Object)"xml");
        ConfigFormatType configFormatType = ConfigFormatType.fromString((String)configFormat);
        switch (configFormatType) {
            case XML_FORMAT: {
                return new XmlConfigDeparser();
            }
            case JSON_FORMAT: {
                return new JsonConfigDeparser();
            }
        }
        throw new DiscoveryException("Invalid config format for '" + configFormat + "'");
    }
}

