/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.parser.json;

import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.plugin.framework.parser.PluginConfigDeparser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConfigDeparser
implements PluginConfigDeparser {
    private static final Logger LOG = LoggerFactory.getLogger(JsonConfigDeparser.class);

    @Override
    public String deparse(RuleEntity ruleEntity) {
        if (ruleEntity == null) {
            throw new DiscoveryException("RuleEntity is null");
        }
        LOG.info("Start to deparse RuleEntity to json...");
        try {
            String config = JsonUtil.toPrettyJson((Object)ruleEntity);
            LOG.info("Rule content=\n{}", (Object)config);
            return config;
        }
        catch (Exception e) {
            throw new DiscoveryException(e.getMessage(), (Throwable)e);
        }
    }
}

