/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.parser.json;

import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.plugin.framework.parser.PluginConfigParser;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConfigParser
implements PluginConfigParser {
    private static final Logger LOG = LoggerFactory.getLogger(JsonConfigParser.class);

    @Override
    public RuleEntity parse(String config) {
        if (StringUtils.isEmpty((CharSequence)config)) {
            throw new DiscoveryException("Config is null or empty");
        }
        LOG.info("Start to parse rule from json...");
        try {
            RuleEntity ruleEntity = (RuleEntity)JsonUtil.fromJson((String)config, RuleEntity.class);
            ruleEntity.setContent(config);
            LOG.info("Rule content=\n{}", (Object)config);
            return ruleEntity;
        }
        catch (Exception e) {
            throw new DiscoveryException(e.getMessage(), (Throwable)e);
        }
    }
}

