/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.parser.xml;

import com.nepxion.discovery.common.entity.AddressWeightEntity;
import com.nepxion.discovery.common.entity.ConditionType;
import com.nepxion.discovery.common.entity.CountFilterEntity;
import com.nepxion.discovery.common.entity.DiscoveryEntity;
import com.nepxion.discovery.common.entity.EscapeType;
import com.nepxion.discovery.common.entity.FilterType;
import com.nepxion.discovery.common.entity.HostFilterEntity;
import com.nepxion.discovery.common.entity.ParameterEntity;
import com.nepxion.discovery.common.entity.ParameterServiceEntity;
import com.nepxion.discovery.common.entity.RegionEntity;
import com.nepxion.discovery.common.entity.RegionFilterEntity;
import com.nepxion.discovery.common.entity.RegionWeightEntity;
import com.nepxion.discovery.common.entity.RegisterEntity;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.StrategyBlacklistEntity;
import com.nepxion.discovery.common.entity.StrategyConditionBlueGreenEntity;
import com.nepxion.discovery.common.entity.StrategyConditionGrayEntity;
import com.nepxion.discovery.common.entity.StrategyEntity;
import com.nepxion.discovery.common.entity.StrategyFailoverEntity;
import com.nepxion.discovery.common.entity.StrategyHeaderEntity;
import com.nepxion.discovery.common.entity.StrategyReleaseEntity;
import com.nepxion.discovery.common.entity.StrategyRouteEntity;
import com.nepxion.discovery.common.entity.StrategyRouteType;
import com.nepxion.discovery.common.entity.VersionEntity;
import com.nepxion.discovery.common.entity.VersionFilterEntity;
import com.nepxion.discovery.common.entity.VersionWeightEntity;
import com.nepxion.discovery.common.entity.WeightEntity;
import com.nepxion.discovery.common.entity.WeightFilterEntity;
import com.nepxion.discovery.common.entity.WeightType;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.common.util.StringUtil;
import com.nepxion.discovery.plugin.framework.parser.PluginConfigDeparser;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlConfigDeparser
implements PluginConfigDeparser {
    private static final Logger LOG = LoggerFactory.getLogger(XmlConfigDeparser.class);
    private static final String INDENT = "    ";

    @Override
    public String deparse(RuleEntity ruleEntity) {
        if (ruleEntity == null) {
            throw new DiscoveryException("RuleEntity is null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.deparseRoot(stringBuilder, ruleEntity);
        String config = stringBuilder.toString();
        ruleEntity.setContent(config);
        LOG.info("Rule content=\n{}", (Object)config);
        return config;
    }

    private void deparseRoot(StringBuilder stringBuilder, RuleEntity ruleEntity) {
        LOG.info("Start to deparse RuleEntity to xml...");
        RegisterEntity registerEntity = ruleEntity.getRegisterEntity();
        DiscoveryEntity discoveryEntity = ruleEntity.getDiscoveryEntity();
        StrategyEntity strategyEntity = ruleEntity.getStrategyEntity();
        StrategyReleaseEntity strategyReleaseEntity = ruleEntity.getStrategyReleaseEntity();
        StrategyFailoverEntity strategyFailoverEntity = ruleEntity.getStrategyFailoverEntity();
        StrategyBlacklistEntity strategyBlacklistEntity = ruleEntity.getStrategyBlacklistEntity();
        ParameterEntity parameterEntity = ruleEntity.getParameterEntity();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuilder.append("<rule>\n");
        if (registerEntity != null) {
            this.deparseRegister(stringBuilder, registerEntity);
        }
        if (discoveryEntity != null) {
            this.deparseDiscovery(stringBuilder, discoveryEntity);
        }
        if (strategyEntity != null) {
            this.deparseStrategy(stringBuilder, strategyEntity);
        }
        if (strategyReleaseEntity != null) {
            this.deparseStrategyRelease(stringBuilder, strategyReleaseEntity);
        }
        if (strategyFailoverEntity != null) {
            this.deparseStrategyFailover(stringBuilder, strategyFailoverEntity);
        }
        if (strategyBlacklistEntity != null) {
            this.deparseStrategyBlacklist(stringBuilder, strategyBlacklistEntity);
        }
        if (parameterEntity != null) {
            this.deparseParameter(stringBuilder, parameterEntity);
        }
        stringBuilder.append("</rule>");
    }

    private void deparseRegister(StringBuilder stringBuilder, RegisterEntity registerEntity) {
        HostFilterEntity hostFilterEntity = registerEntity.getHostFilterEntity();
        CountFilterEntity countFilterEntity = registerEntity.getCountFilterEntity();
        if (hostFilterEntity != null || countFilterEntity != null) {
            stringBuilder.append("    <register>\n");
        }
        if (hostFilterEntity != null) {
            this.deparseHostFilter(stringBuilder, hostFilterEntity);
        }
        if (countFilterEntity != null) {
            this.deparseCountFilter(stringBuilder, countFilterEntity);
        }
        if (hostFilterEntity != null || countFilterEntity != null) {
            stringBuilder.append("    </register>\n");
        }
    }

    private void deparseDiscovery(StringBuilder stringBuilder, DiscoveryEntity discoveryEntity) {
        HostFilterEntity hostFilterEntity = discoveryEntity.getHostFilterEntity();
        VersionFilterEntity versionFilterEntity = discoveryEntity.getVersionFilterEntity();
        RegionFilterEntity regionFilterEntity = discoveryEntity.getRegionFilterEntity();
        WeightFilterEntity weightFilterEntity = discoveryEntity.getWeightFilterEntity();
        if (hostFilterEntity != null || versionFilterEntity != null || regionFilterEntity != null || weightFilterEntity != null) {
            stringBuilder.append("    <discovery>\n");
        }
        if (hostFilterEntity != null) {
            this.deparseHostFilter(stringBuilder, hostFilterEntity);
        }
        if (versionFilterEntity != null) {
            this.deparseVersionFilter(stringBuilder, versionFilterEntity);
        }
        if (regionFilterEntity != null) {
            this.deparseRegionFilter(stringBuilder, regionFilterEntity);
        }
        if (weightFilterEntity != null) {
            this.deparseWeightFilter(stringBuilder, weightFilterEntity);
        }
        if (hostFilterEntity != null || versionFilterEntity != null || regionFilterEntity != null || weightFilterEntity != null) {
            stringBuilder.append("    </discovery>\n");
        }
    }

    private void deparseStrategy(StringBuilder stringBuilder, StrategyEntity strategyEntity) {
        String versionValue = strategyEntity.getVersionValue();
        String regionValue = strategyEntity.getRegionValue();
        String addressValue = strategyEntity.getAddressValue();
        String versionWeightValue = strategyEntity.getVersionWeightValue();
        String regionWeightValue = strategyEntity.getRegionWeightValue();
        if (versionValue != null || regionValue != null || addressValue != null || versionWeightValue != null || regionWeightValue != null) {
            stringBuilder.append("    <strategy>\n");
        }
        if (versionValue != null) {
            stringBuilder.append("        <version>" + versionValue + "</" + "version" + ">\n");
        }
        if (regionValue != null) {
            stringBuilder.append("        <region>" + regionValue + "</" + "region" + ">\n");
        }
        if (addressValue != null) {
            stringBuilder.append("        <address>" + addressValue + "</" + "address" + ">\n");
        }
        if (versionWeightValue != null) {
            stringBuilder.append("        <version-weight>" + versionWeightValue + "</" + "version-weight" + ">\n");
        }
        if (regionWeightValue != null) {
            stringBuilder.append("        <region-weight>" + regionWeightValue + "</" + "region-weight" + ">\n");
        }
        if (versionValue != null || regionValue != null || addressValue != null || versionWeightValue != null || regionWeightValue != null) {
            stringBuilder.append("    </strategy>\n");
        }
    }

    private void deparseStrategyRelease(StringBuilder stringBuilder, StrategyReleaseEntity strategyReleaseEntity) {
        List strategyConditionBlueGreenEntityList = strategyReleaseEntity.getStrategyConditionBlueGreenEntityList();
        List strategyConditionGrayEntityList = strategyReleaseEntity.getStrategyConditionGrayEntityList();
        List strategyRouteEntityList = strategyReleaseEntity.getStrategyRouteEntityList();
        StrategyHeaderEntity strategyHeaderEntity = strategyReleaseEntity.getStrategyHeaderEntity();
        if (CollectionUtils.isNotEmpty((Collection)strategyConditionBlueGreenEntityList) || CollectionUtils.isNotEmpty((Collection)strategyConditionGrayEntityList) || CollectionUtils.isNotEmpty((Collection)strategyRouteEntityList) || strategyHeaderEntity != null) {
            stringBuilder.append("    <strategy-release>\n");
        }
        if (CollectionUtils.isNotEmpty((Collection)strategyConditionBlueGreenEntityList)) {
            this.deparseStrategyConditionBlueGreen(stringBuilder, strategyConditionBlueGreenEntityList);
        }
        if (CollectionUtils.isNotEmpty((Collection)strategyConditionGrayEntityList)) {
            this.deparseStrategyConditionGray(stringBuilder, strategyConditionGrayEntityList);
        }
        if (CollectionUtils.isNotEmpty((Collection)strategyRouteEntityList)) {
            this.deparseStrategyRoute(stringBuilder, strategyRouteEntityList);
        }
        if (strategyHeaderEntity != null) {
            this.deparseStrategyHeader(stringBuilder, strategyHeaderEntity);
        }
        if (CollectionUtils.isNotEmpty((Collection)strategyConditionBlueGreenEntityList) || CollectionUtils.isNotEmpty((Collection)strategyConditionGrayEntityList) || CollectionUtils.isNotEmpty((Collection)strategyRouteEntityList) || strategyHeaderEntity != null) {
            stringBuilder.append("    </strategy-release>\n");
        }
    }

    private void deparseStrategyFailover(StringBuilder stringBuilder, StrategyFailoverEntity strategyFailoverEntity) {
        String versionPreferValue = strategyFailoverEntity.getVersionPreferValue();
        String versionFailoverValue = strategyFailoverEntity.getVersionFailoverValue();
        String regionTransferValue = strategyFailoverEntity.getRegionTransferValue();
        String regionFailoverValue = strategyFailoverEntity.getRegionFailoverValue();
        String environmentFailoverValue = strategyFailoverEntity.getEnvironmentFailoverValue();
        String zoneFailoverValue = strategyFailoverEntity.getZoneFailoverValue();
        String addressFailoverValue = strategyFailoverEntity.getAddressFailoverValue();
        if (versionPreferValue != null || versionFailoverValue != null || regionTransferValue != null || regionFailoverValue != null || environmentFailoverValue != null || zoneFailoverValue != null || addressFailoverValue != null) {
            stringBuilder.append("    <strategy-failover>\n");
        }
        if (versionPreferValue != null) {
            stringBuilder.append("        <version-prefer>" + versionPreferValue + "</" + "version-prefer" + ">\n");
        }
        if (versionFailoverValue != null) {
            stringBuilder.append("        <version-failover>" + versionFailoverValue + "</" + "version-failover" + ">\n");
        }
        if (regionTransferValue != null) {
            stringBuilder.append("        <region-transfer>" + regionTransferValue + "</" + "region-transfer" + ">\n");
        }
        if (regionFailoverValue != null) {
            stringBuilder.append("        <region-failover>" + regionFailoverValue + "</" + "region-failover" + ">\n");
        }
        if (environmentFailoverValue != null) {
            stringBuilder.append("        <env-failover>" + environmentFailoverValue + "</" + "env-failover" + ">\n");
        }
        if (zoneFailoverValue != null) {
            stringBuilder.append("        <zone-failover>" + zoneFailoverValue + "</" + "zone-failover" + ">\n");
        }
        if (addressFailoverValue != null) {
            stringBuilder.append("        <address-failover>" + addressFailoverValue + "</" + "address-failover" + ">\n");
        }
        if (versionPreferValue != null || versionFailoverValue != null || regionTransferValue != null || regionFailoverValue != null || environmentFailoverValue != null || zoneFailoverValue != null || addressFailoverValue != null) {
            stringBuilder.append("    </strategy-failover>\n");
        }
    }

    private void deparseStrategyBlacklist(StringBuilder stringBuilder, StrategyBlacklistEntity strategyBlacklistEntity) {
        String idValue = strategyBlacklistEntity.getIdValue();
        String addressValue = strategyBlacklistEntity.getAddressValue();
        if (idValue != null || addressValue != null) {
            stringBuilder.append("    <strategy-blacklist>\n");
        }
        if (idValue != null) {
            stringBuilder.append("        <id>" + idValue + "</" + "id" + ">\n");
        }
        if (addressValue != null) {
            stringBuilder.append("        <address>" + addressValue + "</" + "address" + ">\n");
        }
        if (idValue != null || addressValue != null) {
            stringBuilder.append("    </strategy-blacklist>\n");
        }
    }

    private void deparseParameter(StringBuilder stringBuilder, ParameterEntity parameterEntity) {
        Map parameterServiceMap = parameterEntity.getParameterServiceMap();
        if (MapUtils.isNotEmpty((Map)parameterServiceMap)) {
            stringBuilder.append("    <parameter>\n");
            for (Map.Entry parameterServiceEntry : parameterServiceMap.entrySet()) {
                List parameterServiceEntityList = (List)parameterServiceEntry.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)parameterServiceEntityList)) continue;
                for (ParameterServiceEntity parameterServiceEntity : parameterServiceEntityList) {
                    stringBuilder.append("        <service");
                    Map parameterMap = parameterServiceEntity.getParameterMap();
                    for (Map.Entry parameterEntry : parameterMap.entrySet()) {
                        String key = (String)parameterEntry.getKey();
                        String value = (String)parameterEntry.getValue();
                        stringBuilder.append(" " + key + "=\"" + value + "\"");
                    }
                    stringBuilder.append("/>\n");
                }
            }
            stringBuilder.append("    </parameter>\n");
        }
    }

    private void deparseHostFilter(StringBuilder stringBuilder, HostFilterEntity hostFilterEntity) {
        FilterType filterType = hostFilterEntity.getFilterType();
        List globalFilterValueList = hostFilterEntity.getFilterValueList();
        Map filterMap = hostFilterEntity.getFilterMap();
        if (CollectionUtils.isNotEmpty((Collection)globalFilterValueList) || MapUtils.isNotEmpty((Map)filterMap)) {
            if (CollectionUtils.isEmpty((Collection)globalFilterValueList)) {
                stringBuilder.append("        <" + filterType.toString() + ">\n");
            } else {
                stringBuilder.append("        <" + filterType.toString() + " " + "filter-value" + "=\"" + StringUtil.convertToString((List)globalFilterValueList) + "\">\n");
            }
        }
        if (MapUtils.isNotEmpty((Map)filterMap)) {
            for (Map.Entry entry : filterMap.entrySet()) {
                String serviceName = (String)entry.getKey();
                List filterValueList = (List)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)filterValueList)) {
                    stringBuilder.append("            <service service-name=\"" + serviceName + "\"/>\n");
                    continue;
                }
                stringBuilder.append("            <service service-name=\"" + serviceName + "\" " + "filter-value" + "=\"" + StringUtil.convertToString((List)filterValueList) + "\"/>\n");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)globalFilterValueList) || MapUtils.isNotEmpty((Map)filterMap)) {
            stringBuilder.append("        </" + filterType.toString() + ">\n");
        }
    }

    private void deparseCountFilter(StringBuilder stringBuilder, CountFilterEntity countFilterEntity) {
        Integer globalFilterValue = countFilterEntity.getFilterValue();
        Map filterMap = countFilterEntity.getFilterMap();
        if (globalFilterValue != null || MapUtils.isNotEmpty((Map)filterMap)) {
            if (globalFilterValue == null) {
                stringBuilder.append("        <count>\n");
            } else {
                stringBuilder.append("        <count filter-value=\"" + globalFilterValue + "\">\n");
            }
        }
        if (MapUtils.isNotEmpty((Map)filterMap)) {
            for (Map.Entry entry : filterMap.entrySet()) {
                String serviceName = (String)entry.getKey();
                Integer filterValue = (Integer)entry.getValue();
                if (filterValue == null) {
                    stringBuilder.append("            <service service-name=\"" + serviceName + "\"/>\n");
                    continue;
                }
                stringBuilder.append("            <service service-name=\"" + serviceName + "\" " + "filter-value" + "=\"" + filterValue + "\"/>\n");
            }
        }
        if (globalFilterValue != null || MapUtils.isNotEmpty((Map)filterMap)) {
            stringBuilder.append("        </count>\n");
        }
    }

    private void deparseVersionFilter(StringBuilder stringBuilder, VersionFilterEntity versionFilterEntity) {
        Map versionEntityMap = versionFilterEntity.getVersionEntityMap();
        if (MapUtils.isNotEmpty((Map)versionEntityMap)) {
            stringBuilder.append("        <version>\n");
            for (Map.Entry entry : versionEntityMap.entrySet()) {
                List versionEntityList = (List)entry.getValue();
                for (VersionEntity versionEntity : versionEntityList) {
                    String consumerServiceName = versionEntity.getConsumerServiceName();
                    String providerServiceName = versionEntity.getProviderServiceName();
                    List consumerVersionValueList = versionEntity.getConsumerVersionValueList();
                    List providerVersionValueList = versionEntity.getProviderVersionValueList();
                    stringBuilder.append("            <service consumer-service-name=\"" + consumerServiceName + "\" " + "provider-service-name" + "=\"" + providerServiceName + "\"");
                    if (CollectionUtils.isNotEmpty((Collection)consumerVersionValueList)) {
                        stringBuilder.append(" consumer-version-value=\"" + StringUtil.convertToString((List)consumerVersionValueList) + "\"");
                    }
                    if (CollectionUtils.isNotEmpty((Collection)providerVersionValueList)) {
                        stringBuilder.append(" provider-version-value=\"" + StringUtil.convertToString((List)providerVersionValueList) + "\"");
                    }
                    stringBuilder.append("/>\n");
                }
            }
            stringBuilder.append("        </version>\n");
        }
    }

    private void deparseRegionFilter(StringBuilder stringBuilder, RegionFilterEntity regionFilterEntity) {
        Map regionEntityMap = regionFilterEntity.getRegionEntityMap();
        if (MapUtils.isNotEmpty((Map)regionEntityMap)) {
            stringBuilder.append("        <region>\n");
            for (Map.Entry entry : regionEntityMap.entrySet()) {
                List regionEntityList = (List)entry.getValue();
                for (RegionEntity regionEntity : regionEntityList) {
                    String consumerServiceName = regionEntity.getConsumerServiceName();
                    String providerServiceName = regionEntity.getProviderServiceName();
                    List consumerVersionValueList = regionEntity.getConsumerRegionValueList();
                    List providerVersionValueList = regionEntity.getProviderRegionValueList();
                    stringBuilder.append("            <service consumer-service-name=\"" + consumerServiceName + "\" " + "provider-service-name" + "=\"" + providerServiceName + "\"");
                    if (CollectionUtils.isNotEmpty((Collection)consumerVersionValueList)) {
                        stringBuilder.append(" consumer-region-value=\"" + StringUtil.convertToString((List)consumerVersionValueList) + "\"");
                    }
                    if (CollectionUtils.isNotEmpty((Collection)providerVersionValueList)) {
                        stringBuilder.append(" provider-region-value=\"" + StringUtil.convertToString((List)providerVersionValueList) + "\"");
                    }
                    stringBuilder.append("/>\n");
                }
            }
            stringBuilder.append("        </region>\n");
        }
    }

    private void deparseWeightFilter(StringBuilder stringBuilder, WeightFilterEntity weightFilterEntity) {
        WeightType type;
        Object weightMap;
        String providerServiceName;
        WeightType type2;
        Map weightMap2;
        String providerServiceName2;
        String consumerServiceName;
        List weightEntityList;
        Map versionWeightEntityMap = weightFilterEntity.getVersionWeightEntityMap();
        List versionWeightEntityList = weightFilterEntity.getVersionWeightEntityList();
        VersionWeightEntity versionWeightEntity = weightFilterEntity.getVersionWeightEntity();
        Map versionWeightMap = versionWeightEntity.getWeightMap();
        Map regionWeightEntityMap = weightFilterEntity.getRegionWeightEntityMap();
        List regionWeightEntityList = weightFilterEntity.getRegionWeightEntityList();
        RegionWeightEntity regionWeightEntity = weightFilterEntity.getRegionWeightEntity();
        Map regionWeightMap = regionWeightEntity.getWeightMap();
        stringBuilder.append("        <weight>\n");
        if (MapUtils.isNotEmpty((Map)versionWeightEntityMap)) {
            for (Map.Entry entry : versionWeightEntityMap.entrySet()) {
                weightEntityList = (List)entry.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)weightEntityList)) continue;
                for (WeightEntity weightEntity : weightEntityList) {
                    consumerServiceName = weightEntity.getConsumerServiceName();
                    providerServiceName2 = weightEntity.getProviderServiceName();
                    weightMap2 = weightEntity.getWeightMap();
                    type2 = weightEntity.getType();
                    stringBuilder.append("            <service consumer-service-name=\"" + consumerServiceName + "\" " + "provider-service-name" + "=\"" + providerServiceName2 + "\" " + "provider-weight-value" + "=\"" + StringUtil.convertToString((Map)weightMap2) + "\" " + "type" + "=\"" + type2 + "\"/>\n");
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)versionWeightEntityList)) {
            for (WeightEntity weightEntity : versionWeightEntityList) {
                providerServiceName = weightEntity.getProviderServiceName();
                weightMap = weightEntity.getWeightMap();
                type = weightEntity.getType();
                stringBuilder.append("            <service provider-service-name=\"" + providerServiceName + "\" " + "provider-weight-value" + "=\"" + StringUtil.convertToString((Map)weightMap) + "\" " + "type" + "=\"" + type + "\"/>\n");
            }
        }
        if (MapUtils.isNotEmpty((Map)versionWeightMap)) {
            stringBuilder.append("            <version provider-weight-value=\"" + StringUtil.convertToString((Map)versionWeightMap) + "\"/>\n");
        }
        if (MapUtils.isNotEmpty((Map)regionWeightEntityMap)) {
            for (Map.Entry entry : regionWeightEntityMap.entrySet()) {
                weightEntityList = (List)entry.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)weightEntityList)) continue;
                for (WeightEntity weightEntity : weightEntityList) {
                    consumerServiceName = weightEntity.getConsumerServiceName();
                    providerServiceName2 = weightEntity.getProviderServiceName();
                    weightMap2 = weightEntity.getWeightMap();
                    type2 = weightEntity.getType();
                    stringBuilder.append("            <service consumer-service-name=\"" + consumerServiceName + "\" " + "provider-service-name" + "=\"" + providerServiceName2 + "\" " + "provider-weight-value" + "=\"" + StringUtil.convertToString((Map)weightMap2) + "\" " + "type" + "=\"" + type2 + "\"/>\n");
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)regionWeightEntityList)) {
            for (WeightEntity weightEntity : regionWeightEntityList) {
                providerServiceName = weightEntity.getProviderServiceName();
                weightMap = weightEntity.getWeightMap();
                type = weightEntity.getType();
                stringBuilder.append("            <service provider-service-name=\"" + providerServiceName + "\" " + "provider-weight-value" + "=\"" + StringUtil.convertToString((Map)weightMap) + "\" " + "type" + "=\"" + type + "\"/>\n");
            }
        }
        if (MapUtils.isNotEmpty((Map)regionWeightMap)) {
            stringBuilder.append("            <region provider-weight-value=\"" + StringUtil.convertToString((Map)regionWeightMap) + "\"/>\n");
        }
        stringBuilder.append("        </weight>\n");
    }

    private void deparseStrategyConditionBlueGreen(StringBuilder stringBuilder, List<StrategyConditionBlueGreenEntity> strategyConditionBlueGreenEntityList) {
        if (CollectionUtils.isNotEmpty(strategyConditionBlueGreenEntityList)) {
            stringBuilder.append("        <conditions type=\"" + ConditionType.BLUE_GREEN.toString() + "\">\n");
            for (StrategyConditionBlueGreenEntity strategyConditionBlueGreenEntity : strategyConditionBlueGreenEntityList) {
                String id = strategyConditionBlueGreenEntity.getId();
                String expression = EscapeType.escape((String)strategyConditionBlueGreenEntity.getExpression(), (boolean)true);
                String versionId = strategyConditionBlueGreenEntity.getVersionId();
                String regionId = strategyConditionBlueGreenEntity.getRegionId();
                String addressId = strategyConditionBlueGreenEntity.getAddressId();
                String versionWeightId = strategyConditionBlueGreenEntity.getVersionWeightId();
                String regionWeightId = strategyConditionBlueGreenEntity.getRegionWeightId();
                if (StringUtils.isNotEmpty((CharSequence)expression)) {
                    stringBuilder.append("            <condition id=\"" + id + "\" " + "expression" + "=\"" + expression + "\"");
                } else {
                    stringBuilder.append("            <condition id=\"" + id + "\"");
                }
                if (versionId != null) {
                    stringBuilder.append(" version-id=\"" + versionId + "\"");
                }
                if (regionId != null) {
                    stringBuilder.append(" region-id=\"" + regionId + "\"");
                }
                if (addressId != null) {
                    stringBuilder.append(" address-id=\"" + addressId + "\"");
                }
                if (versionWeightId != null) {
                    stringBuilder.append(" version-weight-id=\"" + versionWeightId + "\"");
                }
                if (regionWeightId != null) {
                    stringBuilder.append(" region-weight-id=\"" + regionWeightId + "\"");
                }
                stringBuilder.append("/>\n");
            }
            stringBuilder.append("        </conditions>\n");
        }
    }

    private void deparseStrategyConditionGray(StringBuilder stringBuilder, List<StrategyConditionGrayEntity> strategyConditionGrayEntityList) {
        if (CollectionUtils.isNotEmpty(strategyConditionGrayEntityList)) {
            stringBuilder.append("        <conditions type=\"" + ConditionType.GRAY.toString() + "\">\n");
            for (StrategyConditionGrayEntity strategyConditionGrayEntity : strategyConditionGrayEntityList) {
                String id = strategyConditionGrayEntity.getId();
                String expression = EscapeType.escape((String)strategyConditionGrayEntity.getExpression(), (boolean)true);
                VersionWeightEntity versionWeightEntity = strategyConditionGrayEntity.getVersionWeightEntity();
                RegionWeightEntity regionWeightEntity = strategyConditionGrayEntity.getRegionWeightEntity();
                AddressWeightEntity addressWeightEntity = strategyConditionGrayEntity.getAddressWeightEntity();
                if (StringUtils.isNotEmpty((CharSequence)expression)) {
                    stringBuilder.append("            <condition id=\"" + id + "\" " + "expression" + "=\"" + expression + "\"");
                } else {
                    stringBuilder.append("            <condition id=\"" + id + "\"");
                }
                if (versionWeightEntity != null) {
                    stringBuilder.append(" version-id=\"" + StringUtil.convertToString((Map)versionWeightEntity.getWeightMap()) + "\"");
                }
                if (regionWeightEntity != null) {
                    stringBuilder.append(" region-id=\"" + StringUtil.convertToString((Map)regionWeightEntity.getWeightMap()) + "\"");
                }
                if (addressWeightEntity != null) {
                    stringBuilder.append(" address-id=\"" + StringUtil.convertToString((Map)addressWeightEntity.getWeightMap()) + "\"");
                }
                stringBuilder.append("/>\n");
            }
            stringBuilder.append("        </conditions>\n");
        }
    }

    private void deparseStrategyRoute(StringBuilder stringBuilder, List<StrategyRouteEntity> strategyRouteEntityList) {
        if (CollectionUtils.isNotEmpty(strategyRouteEntityList)) {
            stringBuilder.append("        <routes>\n");
            for (StrategyRouteEntity strategyRouteEntity : strategyRouteEntityList) {
                String id = strategyRouteEntity.getId();
                StrategyRouteType type = strategyRouteEntity.getType();
                String value = strategyRouteEntity.getValue();
                stringBuilder.append("            <route id=\"" + id + "\" " + "type" + "=\"" + type + "\">" + value + "</" + "route" + ">\n");
            }
            stringBuilder.append("        </routes>\n");
        }
    }

    private void deparseStrategyHeader(StringBuilder stringBuilder, StrategyHeaderEntity strategyHeaderEntity) {
        Map headerMap = strategyHeaderEntity.getHeaderMap();
        if (MapUtils.isNotEmpty((Map)headerMap)) {
            stringBuilder.append("        <header>" + JsonUtil.toJson((Object)headerMap) + "</" + "header" + ">\n");
        }
    }
}

