/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.context;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;

public class PluginContextAware
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private Environment environment;
    private static ApplicationContext staticApplicationContext;
    private static Environment staticEnvironment;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.environment = applicationContext.getEnvironment();
        staticApplicationContext = applicationContext;
        staticEnvironment = applicationContext.getEnvironment();
    }

    public Object getBean(String name) throws BeansException {
        return this.applicationContext.getBean(name);
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        return (T)this.applicationContext.getBean(name, requiredType);
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        return this.applicationContext.getBean(name, args);
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return (T)this.applicationContext.getBean(requiredType);
    }

    public <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
        return (T)this.applicationContext.getBean(requiredType, args);
    }

    public boolean containsBean(String name) {
        return this.applicationContext.containsBean(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.applicationContext.isSingleton(name);
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        return this.applicationContext.isPrototype(name);
    }

    public boolean isTypeMatch(String name, ResolvableType typeToMatch) throws NoSuchBeanDefinitionException {
        return this.applicationContext.isTypeMatch(name, typeToMatch);
    }

    public boolean isTypeMatch(String name, Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        return this.applicationContext.isTypeMatch(name, typeToMatch);
    }

    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return this.applicationContext.getType(name);
    }

    public String[] getAliases(String name) {
        return this.applicationContext.getAliases(name);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public static ApplicationContext getStaticApplicationContext() {
        return staticApplicationContext;
    }

    public static Environment getStaticEnvironment() {
        return staticEnvironment;
    }

    public String getConfigFormat() {
        return PluginContextAware.getConfigFormat(this.environment);
    }

    public String getConfigPath() {
        return PluginContextAware.getConfigPath(this.environment);
    }

    public String getApplicationName() {
        return PluginContextAware.getApplicationName(this.environment);
    }

    public String getApplicationType() {
        return PluginContextAware.getApplicationType(this.environment);
    }

    public String getApplicationUUId() {
        return PluginContextAware.getApplicationUUId(this.environment);
    }

    public String getGroupKey() {
        return PluginContextAware.getGroupKey(this.environment);
    }

    public String getDefaultPropertiesPath() {
        return PluginContextAware.getDefaultPropertiesPath(this.environment);
    }

    public Boolean isGroupGeneratorEnabled() {
        return PluginContextAware.isGroupGeneratorEnabled(this.environment);
    }

    public Integer getGroupGeneratorLength() {
        return PluginContextAware.getGroupGeneratorLength(this.environment);
    }

    public String getGroupGeneratorCharacter() {
        return PluginContextAware.getGroupGeneratorCharacter(this.environment);
    }

    public Boolean isGitGeneratorEnabled() {
        return PluginContextAware.isGitGeneratorEnabled(this.environment);
    }

    public String getGitGeneratorPath() {
        return PluginContextAware.getGitGeneratorPath(this.environment);
    }

    public String getGitVersionKey() {
        return PluginContextAware.getGitVersionKey(this.environment);
    }

    public String getContextPath() {
        return PluginContextAware.getContextPath(this.environment);
    }

    public static String getConfigFormat(Environment environment) {
        return (String)environment.getProperty("spring.application.config.format", String.class, (Object)"xml");
    }

    public static String getConfigPath(Environment environment) {
        return (String)environment.getProperty("spring.application.config.path", String.class, (Object)(StringUtils.equals((CharSequence)PluginContextAware.getConfigFormat(environment), (CharSequence)"xml") ? "classpath:rule.xml" : "classpath:rule.json"));
    }

    public static String getApplicationName(Environment environment) {
        return (String)environment.getProperty("spring.application.name", String.class, (Object)"unknown");
    }

    public static String getApplicationType(Environment environment) {
        return (String)environment.getProperty("spring.application.type", String.class, (Object)"unknown");
    }

    public static String getApplicationGatewayType(Environment environment) {
        return (String)environment.getProperty("spring.application.gateway.type", String.class);
    }

    public static String getApplicationProtocol(Environment environment) {
        return (String)environment.getProperty("spring.application.protocol", String.class, (Object)"http");
    }

    public static String getApplicationUUId(Environment environment) {
        return (String)environment.getProperty("spring.application.uuid", String.class, (Object)"unknown");
    }

    public static String getGroupKey(Environment environment) {
        return (String)environment.getProperty("spring.application.group.key", String.class, (Object)"group");
    }

    public static String getDefaultPropertiesPath(Environment environment) {
        return (String)environment.getProperty("spring.application.default.properties.path", String.class, (Object)"spring-application-default.properties");
    }

    public static Boolean isGroupGeneratorEnabled(Environment environment) {
        return (Boolean)environment.getProperty("spring.application.group.generator.enabled", Boolean.class, (Object)Boolean.FALSE);
    }

    public static Integer getGroupGeneratorLength(Environment environment) {
        return (Integer)environment.getProperty("spring.application.group.generator.length", Integer.class, (Object)-1);
    }

    public static String getGroupGeneratorCharacter(Environment environment) {
        return (String)environment.getProperty("spring.application.group.generator.character", String.class, (Object)"");
    }

    public static Boolean isGitGeneratorEnabled(Environment environment) {
        return (Boolean)environment.getProperty("spring.application.git.generator.enabled", Boolean.class, (Object)Boolean.FALSE);
    }

    public static String getGitGeneratorPath(Environment environment) {
        return (String)environment.getProperty("spring.application.git.generator.path", String.class, (Object)"classpath:git.properties");
    }

    public static String getGitVersionKey(Environment environment) {
        return (String)environment.getProperty("spring.application.git.version.key", String.class, (Object)"{git.commit.time}-{git.total.commit.count}");
    }

    public static String getContextPath(Environment environment) {
        return (String)environment.getProperty("server.servlet.context-path", String.class, (Object)"/");
    }
}

