/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.decorator;

import com.nepxion.discovery.common.delegate.DiscoveryClientDelegate;
import com.nepxion.discovery.plugin.framework.listener.discovery.DiscoveryListenerExecutor;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ConfigurableApplicationContext;

public class DiscoveryClientDecorator
implements DiscoveryClient,
DiscoveryClientDelegate<DiscoveryClient> {
    private DiscoveryClient discoveryClient;
    private ConfigurableApplicationContext applicationContext;

    public DiscoveryClientDecorator(DiscoveryClient discoveryClient, ConfigurableApplicationContext applicationContext) {
        this.discoveryClient = discoveryClient;
        this.applicationContext = applicationContext;
    }

    public DiscoveryClient getDelegate() {
        return this.discoveryClient;
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        List<ServiceInstance> instances = this.getRealInstances(serviceId);
        try {
            DiscoveryListenerExecutor discoveryListenerExecutor = (DiscoveryListenerExecutor)this.applicationContext.getBean(DiscoveryListenerExecutor.class);
            discoveryListenerExecutor.onGetInstances(serviceId, instances);
        }
        catch (BeansException beansException) {
            // empty catch block
        }
        return instances;
    }

    public List<ServiceInstance> getRealInstances(String serviceId) {
        return this.discoveryClient.getInstances(serviceId);
    }

    public List<String> getServices() {
        List<String> services = this.getRealServices();
        try {
            DiscoveryListenerExecutor discoveryListenerExecutor = (DiscoveryListenerExecutor)this.applicationContext.getBean(DiscoveryListenerExecutor.class);
            discoveryListenerExecutor.onGetServices(services);
        }
        catch (BeansException beansException) {
            // empty catch block
        }
        return services;
    }

    public List<String> getRealServices() {
        return this.discoveryClient.getServices();
    }

    public String description() {
        return this.discoveryClient.description();
    }
}

