/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.decorator;

import com.google.common.base.Optional;
import com.nepxion.discovery.common.entity.WeightFilterEntity;
import com.nepxion.discovery.plugin.framework.loadbalance.DiscoveryEnabledLoadBalance;
import com.nepxion.discovery.plugin.framework.loadbalance.weight.RuleWeightRandomLoadBalance;
import com.nepxion.discovery.plugin.framework.loadbalance.weight.StrategyWeightRandomLoadBalance;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.PredicateBasedRule;
import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class PredicateBasedRuleDecorator
extends PredicateBasedRule {
    @Autowired
    private StrategyWeightRandomLoadBalance<WeightFilterEntity> strategyWeightRandomLoadBalance;
    @Autowired
    private RuleWeightRandomLoadBalance<WeightFilterEntity> ruleWeightRandomLoadBalance;
    @Autowired(required=false)
    private DiscoveryEnabledLoadBalance discoveryEnabledLoadBalance;

    private List<Server> getServerList(Object key) {
        return this.getPredicate().getEligibleServers(this.getLoadBalancer().getAllServers(), key);
    }

    public Server choose(Object key) {
        WeightFilterEntity ruleWeightFilterEntity;
        boolean isTriggered = false;
        WeightFilterEntity strategyWeightFilterEntity = (WeightFilterEntity)this.strategyWeightRandomLoadBalance.getT();
        if (strategyWeightFilterEntity != null && strategyWeightFilterEntity.hasWeight()) {
            isTriggered = true;
            List<Server> serverList = this.getServerList(key);
            boolean isWeightChecked = this.strategyWeightRandomLoadBalance.checkWeight(serverList, strategyWeightFilterEntity);
            if (isWeightChecked) {
                try {
                    return this.strategyWeightRandomLoadBalance.choose(serverList, strategyWeightFilterEntity);
                }
                catch (Exception e) {
                    return this.filterChoose(key);
                }
            }
            return this.filterChoose(key);
        }
        if (!isTriggered && (ruleWeightFilterEntity = (WeightFilterEntity)this.ruleWeightRandomLoadBalance.getT()) != null && ruleWeightFilterEntity.hasWeight()) {
            List<Server> serverList = this.getServerList(key);
            boolean isWeightChecked = this.ruleWeightRandomLoadBalance.checkWeight(serverList, ruleWeightFilterEntity);
            if (isWeightChecked) {
                try {
                    return this.ruleWeightRandomLoadBalance.choose(serverList, ruleWeightFilterEntity);
                }
                catch (Exception e) {
                    return this.filterChoose(key);
                }
            }
            return this.filterChoose(key);
        }
        return this.filterChoose(key);
    }

    public Server filterChoose(Object key) {
        Optional server;
        ILoadBalancer lb = this.getLoadBalancer();
        ArrayList serverList = new ArrayList();
        serverList.addAll(lb.getAllServers());
        if (this.discoveryEnabledLoadBalance != null) {
            this.discoveryEnabledLoadBalance.filter(serverList);
        }
        if ((server = this.getPredicate().chooseRoundRobinAfterFiltering(serverList, key)).isPresent()) {
            return (Server)server.get();
        }
        return null;
    }
}

