/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.loadbalance.weight;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.tuple.Pair;

public class ArrayWeightRandom<K, V extends Number> {
    private List<K> items = new ArrayList<K>();
    private double[] weights;

    public ArrayWeightRandom(List<Pair<K, V>> pairlist) {
        this.calculateWeightS(pairlist);
    }

    public void calculateWeightS(List<Pair<K, V>> pairlist) {
        this.items.clear();
        double originWeightSum = 0.0;
        for (Pair<K, V> pair : pairlist) {
            double weight = ((Number)pair.getValue()).doubleValue();
            if (weight <= 0.0) continue;
            this.items.add(pair.getKey());
            if (Double.isInfinite(weight)) {
                weight = 10000.0;
            }
            if (Double.isNaN(weight)) {
                weight = 1.0;
            }
            originWeightSum += weight;
        }
        double[] actualWeightRatios = new double[this.items.size()];
        int index = 0;
        for (Pair<K, V> pair : pairlist) {
            double weight = ((Number)pair.getValue()).doubleValue();
            if (weight <= 0.0) continue;
            actualWeightRatios[index++] = weight / originWeightSum;
        }
        this.weights = new double[this.items.size()];
        double weightRangeStartPos = 0.0;
        for (int i = 0; i < index; ++i) {
            this.weights[i] = weightRangeStartPos + actualWeightRatios[i];
            weightRangeStartPos += actualWeightRatios[i];
        }
    }

    public K random() {
        double random = ThreadLocalRandom.current().nextDouble();
        int index = Arrays.binarySearch(this.weights, random);
        if (index >= 0) {
            return this.items.get(index);
        }
        index = -index - 1;
        if (index < this.weights.length && random < this.weights[index]) {
            return this.items.get(index);
        }
        return this.items.get(0);
    }
}

