/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.util;

import com.nepxion.discovery.common.util.PropertiesUtil;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.core.env.Environment;

public class MetadataUtil {
    public static void filter(Map<String, String> metadata, Environment environment) {
        Properties properties = System.getProperties();
        Set<String> propertyNames = properties.stringPropertyNames();
        for (String propertyName : propertyNames) {
            if (!propertyName.startsWith("metadata.")) continue;
            String key = propertyName.substring("metadata.".length());
            String value = properties.get(propertyName).toString();
            metadata.put(key, value);
        }
        Properties enrichProperties = new Properties();
        PropertiesUtil.enrichProperties((Properties)enrichProperties, (Environment)environment, (String)"spring.cloud.discovery", (boolean)false, (boolean)true);
        Set<String> enrichPropertyNames = enrichProperties.stringPropertyNames();
        for (String enrichPropertyName : enrichPropertyNames) {
            if (!enrichPropertyName.startsWith("metadata.")) continue;
            String key = enrichPropertyName.substring("metadata.".length());
            String value = enrichProperties.get(enrichPropertyName).toString();
            if (metadata.containsKey(key)) continue;
            metadata.put(key, value);
        }
    }

    public static void filter(List<String> metadata, Environment environment) {
        Properties properties = System.getProperties();
        Set<String> propertyNames = properties.stringPropertyNames();
        for (String propertyName : propertyNames) {
            if (!propertyName.startsWith("metadata.")) continue;
            String key = propertyName.substring("metadata.".length());
            String value = properties.get(propertyName).toString();
            int index = MetadataUtil.getIndex(metadata, key);
            if (index > -1) {
                metadata.set(index, key + "=" + value);
                continue;
            }
            metadata.add(key + "=" + value);
        }
        Properties enrichProperties = new Properties();
        PropertiesUtil.enrichProperties((Properties)enrichProperties, (Environment)environment, (String)"spring.cloud.discovery", (boolean)false, (boolean)true);
        Set<String> enrichPropertyNames = enrichProperties.stringPropertyNames();
        for (String enrichPropertyName : enrichPropertyNames) {
            if (!enrichPropertyName.startsWith("metadata.")) continue;
            String key = enrichPropertyName.substring("metadata.".length());
            String value = enrichProperties.get(enrichPropertyName).toString();
            int index = MetadataUtil.getIndex(metadata, key);
            if (index > -1) continue;
            metadata.add(key + "=" + value);
        }
    }

    public static int getIndex(List<String> metadata, String key) {
        for (int i = 0; i < metadata.size(); ++i) {
            String value = metadata.get(i);
            if (!value.startsWith(key + "=")) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsKey(List<String> metadata, String key) {
        for (String value : metadata) {
            if (!value.startsWith(key + "=")) continue;
            return true;
        }
        return false;
    }
}

