/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.registercenter.nacos.context;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.registry.NacosServiceRegistry;
import com.nepxion.discovery.common.context.DiscoveryMetaDataPreInstallation;
import com.nepxion.discovery.common.entity.DiscoveryType;
import com.nepxion.discovery.plugin.framework.adapter.ApplicationInfoAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginApplicationContextInitializer;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.util.MetadataUtil;
import com.nepxion.discovery.plugin.registercenter.nacos.decorator.NacosServiceRegistryDecorator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.SpringBootVersion;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class NacosApplicationContextInitializer
extends PluginApplicationContextInitializer {
    protected Object afterInitialization(ConfigurableApplicationContext applicationContext, Object bean, String beanName) throws BeansException {
        if (bean instanceof NacosServiceRegistry) {
            NacosServiceRegistry nacosServiceRegistry = (NacosServiceRegistry)bean;
            NacosServiceManager nacosServiceManager = (NacosServiceManager)applicationContext.getBean(NacosServiceManager.class);
            NacosDiscoveryProperties nacosDiscoveryProperties = (NacosDiscoveryProperties)applicationContext.getBean(NacosDiscoveryProperties.class);
            return new NacosServiceRegistryDecorator(nacosServiceManager, nacosDiscoveryProperties, nacosServiceRegistry, applicationContext);
        }
        if (bean instanceof NacosDiscoveryProperties) {
            String gitVersion;
            ConfigurableEnvironment environment = applicationContext.getEnvironment();
            NacosDiscoveryProperties nacosDiscoveryProperties = (NacosDiscoveryProperties)bean;
            Map metadata = nacosDiscoveryProperties.getMetadata();
            String groupKey = PluginContextAware.getGroupKey((Environment)environment);
            String prefixGroup = this.getPrefixGroup(applicationContext);
            if (StringUtils.isNotEmpty((CharSequence)prefixGroup)) {
                metadata.put(groupKey, prefixGroup);
            }
            if (StringUtils.isNotEmpty((CharSequence)(gitVersion = this.getGitVersion(applicationContext)))) {
                metadata.put("version", gitVersion);
            }
            metadata.put("spring_boot_version", SpringBootVersion.getVersion());
            metadata.put("spring_application_name", PluginContextAware.getApplicationName((Environment)environment));
            metadata.put("spring_application_type", PluginContextAware.getApplicationType((Environment)environment));
            String applicationGatewayType = PluginContextAware.getApplicationGatewayType((Environment)environment);
            if (StringUtils.isNotEmpty((CharSequence)applicationGatewayType)) {
                metadata.put("spring_application_gateway_type", applicationGatewayType);
            }
            metadata.put("spring_application_protocol", PluginContextAware.getApplicationProtocol((Environment)environment));
            metadata.put("spring_application_uuid", PluginContextAware.getApplicationUUId((Environment)environment));
            metadata.put("spring_application_discovery_plugin", DiscoveryType.NACOS.toString());
            metadata.put("spring_application_discovery_version", "6.21.0");
            String agentVersion = System.getProperty("spring.application.discovery.agent.version");
            if (StringUtils.isNotEmpty((CharSequence)agentVersion)) {
                metadata.put("spring_application_discovery_agent_version", agentVersion);
            }
            metadata.put("spring_application_group_key", groupKey);
            metadata.put("spring_application_context-path", PluginContextAware.getContextPath((Environment)environment));
            try {
                ApplicationInfoAdapter applicationInfoAdapter = (ApplicationInfoAdapter)applicationContext.getBean(ApplicationInfoAdapter.class);
                if (applicationInfoAdapter != null) {
                    metadata.put("spring_application_app_id", applicationInfoAdapter.getAppId());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Map.Entry entry : DiscoveryMetaDataPreInstallation.getMetadata().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                metadata.put(key, value);
            }
            MetadataUtil.filter((Map)metadata, (Environment)environment);
            return bean;
        }
        return bean;
    }
}

