/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.gateway.configuration;

import com.nepxion.discovery.common.apollo.proccessor.ApolloProcessor;
import com.nepxion.discovery.common.consul.proccessor.ConsulProcessor;
import com.nepxion.discovery.common.etcd.proccessor.EtcdProcessor;
import com.nepxion.discovery.common.nacos.proccessor.NacosProcessor;
import com.nepxion.discovery.common.redis.proccessor.RedisProcessor;
import com.nepxion.discovery.common.zookeeper.proccessor.ZookeeperProcessor;
import com.nepxion.discovery.plugin.strategy.gateway.context.GatewayStrategyContextListener;
import com.nepxion.discovery.plugin.strategy.gateway.filter.DefaultGatewayStrategyClearFilter;
import com.nepxion.discovery.plugin.strategy.gateway.filter.DefaultGatewayStrategyRouteFilter;
import com.nepxion.discovery.plugin.strategy.gateway.filter.GatewayStrategyClearFilter;
import com.nepxion.discovery.plugin.strategy.gateway.filter.GatewayStrategyRouteFilter;
import com.nepxion.discovery.plugin.strategy.gateway.filter.SkyWalkingGatewayStrategyFilter;
import com.nepxion.discovery.plugin.strategy.gateway.monitor.DefaultGatewayStrategyMonitor;
import com.nepxion.discovery.plugin.strategy.gateway.monitor.GatewayStrategyMonitor;
import com.nepxion.discovery.plugin.strategy.gateway.processor.GatewayStrategyRouteApolloProcessor;
import com.nepxion.discovery.plugin.strategy.gateway.processor.GatewayStrategyRouteConsulProcessor;
import com.nepxion.discovery.plugin.strategy.gateway.processor.GatewayStrategyRouteEtcdProcessor;
import com.nepxion.discovery.plugin.strategy.gateway.processor.GatewayStrategyRouteNacosProcessor;
import com.nepxion.discovery.plugin.strategy.gateway.processor.GatewayStrategyRouteRedisProcessor;
import com.nepxion.discovery.plugin.strategy.gateway.processor.GatewayStrategyRouteZookeeperProcessor;
import com.nepxion.discovery.plugin.strategy.gateway.route.DefaultGatewayStrategyRoute;
import com.nepxion.discovery.plugin.strategy.gateway.route.GatewayStrategyRoute;
import com.nepxion.discovery.plugin.strategy.gateway.wrapper.DefaultGatewayStrategyCallableWrapper;
import com.nepxion.discovery.plugin.strategy.gateway.wrapper.GatewayStrategyCallableWrapper;
import org.apache.skywalking.apm.agent.core.context.TracingContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.ribbon.RibbonClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@AutoConfigureBefore(value={RibbonClientConfiguration.class})
public class GatewayStrategyAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GatewayStrategyRouteFilter gatewayStrategyRouteFilter() {
        return new DefaultGatewayStrategyRouteFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    public GatewayStrategyClearFilter gatewayStrategyClearFilter() {
        return new DefaultGatewayStrategyClearFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.application.strategy.monitor.enabled"}, matchIfMissing=false)
    public GatewayStrategyMonitor gatewayStrategyMonitor() {
        return new DefaultGatewayStrategyMonitor();
    }

    @Bean
    @ConditionalOnMissingBean
    public GatewayStrategyRoute gatewayStrategyRoute() {
        return new DefaultGatewayStrategyRoute();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.application.strategy.hystrix.threadlocal.supported"}, matchIfMissing=false)
    public GatewayStrategyCallableWrapper gatewayStrategyCallableWrapper() {
        return new DefaultGatewayStrategyCallableWrapper();
    }

    @Bean
    public GatewayStrategyContextListener gatewayStrategyContextListener() {
        return new GatewayStrategyContextListener();
    }

    @ConditionalOnClass(value={TracingContext.class})
    protected static class SkywalkingStrategyConfiguration {
        @Autowired
        private ConfigurableEnvironment environment;

        protected SkywalkingStrategyConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"spring.application.strategy.monitor.enabled"}, matchIfMissing=false)
        public SkyWalkingGatewayStrategyFilter skyWalkingGatewayStrategyFilter() {
            Boolean skywalkingTraceIdEnabled = (Boolean)this.environment.getProperty("spring.application.strategy.gateway.skywalking.traceid.enabled", Boolean.class, (Object)Boolean.TRUE);
            if (skywalkingTraceIdEnabled.booleanValue()) {
                return new SkyWalkingGatewayStrategyFilter();
            }
            return null;
        }
    }

    @ConditionalOnClass(value={EtcdProcessor.class})
    @ConditionalOnProperty(value={"spring.application.strategy.gateway.dynamic.route.enabled"}, matchIfMissing=false)
    protected static class GatewayRouteEtcdConfiguration {
        protected GatewayRouteEtcdConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.gateway.discovery.locator.enabled"}, havingValue="false", matchIfMissing=true)
        public EtcdProcessor gatewayStrategyRouteEtcdProcessor() {
            return new GatewayStrategyRouteEtcdProcessor();
        }
    }

    @ConditionalOnClass(value={ConsulProcessor.class})
    @ConditionalOnProperty(value={"spring.application.strategy.gateway.dynamic.route.enabled"}, matchIfMissing=false)
    protected static class GatewayRouteConsulConfiguration {
        protected GatewayRouteConsulConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.gateway.discovery.locator.enabled"}, havingValue="false", matchIfMissing=true)
        public ConsulProcessor gatewayStrategyRouteConsulProcessor() {
            return new GatewayStrategyRouteConsulProcessor();
        }
    }

    @ConditionalOnClass(value={ZookeeperProcessor.class})
    @ConditionalOnProperty(value={"spring.application.strategy.gateway.dynamic.route.enabled"}, matchIfMissing=false)
    protected static class GatewayRouteZookeeperConfiguration {
        protected GatewayRouteZookeeperConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.gateway.discovery.locator.enabled"}, havingValue="false", matchIfMissing=true)
        public ZookeeperProcessor gatewayStrategyRouteZookeeperProcessor() {
            return new GatewayStrategyRouteZookeeperProcessor();
        }
    }

    @ConditionalOnClass(value={RedisProcessor.class})
    @ConditionalOnProperty(value={"spring.application.strategy.gateway.dynamic.route.enabled"}, matchIfMissing=false)
    protected static class GatewayRouteRedisConfiguration {
        protected GatewayRouteRedisConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.gateway.discovery.locator.enabled"}, havingValue="false", matchIfMissing=true)
        public RedisProcessor gatewayStrategyRouteRedisProcessor() {
            return new GatewayStrategyRouteRedisProcessor();
        }
    }

    @ConditionalOnClass(value={ApolloProcessor.class})
    @ConditionalOnProperty(value={"spring.application.strategy.gateway.dynamic.route.enabled"}, matchIfMissing=false)
    protected static class GatewayRouteApolloConfiguration {
        protected GatewayRouteApolloConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.gateway.discovery.locator.enabled"}, havingValue="false", matchIfMissing=true)
        public ApolloProcessor gatewayStrategyRouteApolloProcessor() {
            return new GatewayStrategyRouteApolloProcessor();
        }
    }

    @ConditionalOnClass(value={NacosProcessor.class})
    @ConditionalOnProperty(value={"spring.application.strategy.gateway.dynamic.route.enabled"}, matchIfMissing=false)
    protected static class GatewayRouteNacosConfiguration {
        protected GatewayRouteNacosConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.gateway.discovery.locator.enabled"}, havingValue="false", matchIfMissing=true)
        public NacosProcessor gatewayStrategyRouteNacosProcessor() {
            return new GatewayStrategyRouteNacosProcessor();
        }
    }
}

