/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.gateway.context;

import com.nepxion.discovery.plugin.strategy.context.AbstractStrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.gateway.context.GatewayStrategyContext;
import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class GatewayStrategyContextHolder
extends AbstractStrategyContextHolder {
    public ServerWebExchange getExchange() {
        return GatewayStrategyContext.getCurrentContext().getExchange();
    }

    public ServerHttpRequest getServerHttpRequest() {
        ServerWebExchange exchange = this.getExchange();
        if (exchange == null) {
            return null;
        }
        ServerHttpRequest request = exchange.getRequest();
        if (request == null) {
            return null;
        }
        return request;
    }

    public Enumeration<String> getHeaderNames() {
        ServerHttpRequest request = this.getServerHttpRequest();
        if (request == null) {
            return null;
        }
        Set headerNameSet = request.getHeaders().keySet();
        return Collections.enumeration(headerNameSet);
    }

    public String getHeader(String name) {
        ServerHttpRequest request = this.getServerHttpRequest();
        if (request == null) {
            return null;
        }
        return request.getHeaders().getFirst(name);
    }

    public String getParameter(String name) {
        ServerHttpRequest request = this.getServerHttpRequest();
        if (request == null) {
            return null;
        }
        return (String)request.getQueryParams().getFirst((Object)name);
    }

    public HttpCookie getHttpCookie(String name) {
        ServerHttpRequest request = this.getServerHttpRequest();
        if (request == null) {
            return null;
        }
        return (HttpCookie)request.getCookies().getFirst((Object)name);
    }

    public String getCookie(String name) {
        HttpCookie cookie = this.getHttpCookie(name);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public URI getURI() {
        ServerHttpRequest request = this.getServerHttpRequest();
        if (request == null) {
            return null;
        }
        return request.getURI();
    }
}

