/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.gateway.filter;

import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.gateway.context.GatewayStrategyContext;
import com.nepxion.discovery.plugin.strategy.gateway.filter.GatewayStrategyFilterResolver;
import com.nepxion.discovery.plugin.strategy.gateway.filter.GatewayStrategyRouteFilter;
import com.nepxion.discovery.plugin.strategy.gateway.monitor.GatewayStrategyMonitor;
import com.nepxion.discovery.plugin.strategy.wrapper.StrategyWrapper;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractGatewayStrategyRouteFilter
implements GatewayStrategyRouteFilter {
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected StrategyWrapper strategyWrapper;
    @Autowired(required=false)
    protected GatewayStrategyMonitor gatewayStrategyMonitor;
    @Value(value="${spring.application.strategy.gateway.header.priority:true}")
    protected Boolean gatewayHeaderPriority;
    @Value(value="${spring.application.strategy.gateway.original.header.ignored:true}")
    protected Boolean gatewayOriginalHeaderIgnored;
    @Value(value="${spring.application.strategy.gateway.core.header.transmission.enabled:true}")
    protected Boolean gatewayCoreHeaderTransmissionEnabled;
    @Value(value="${spring.application.strategy.gateway.route.filter.order:9000}")
    protected Integer filterOrder;

    public int getOrder() {
        return this.filterOrder;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        String path;
        GatewayStrategyContext.getCurrentContext().setExchange(exchange);
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpRequest.Builder requestBuilder = request.mutate();
        this.applyInnerHeader(request, requestBuilder);
        this.applyOuterHeader(request, requestBuilder);
        if (this.gatewayStrategyMonitor != null) {
            this.gatewayStrategyMonitor.monitor(exchange);
        }
        if ((path = request.getPath().toString()).contains("inspector/inspect")) {
            GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "endpoint-inspector-inspect", this.pluginAdapter.getPluginInfo(null), true);
        }
        ServerHttpRequest newRequest = requestBuilder.build();
        ServerWebExchange newExchange = exchange.mutate().request(newRequest).build();
        GatewayStrategyContext.getCurrentContext().setExchange(newExchange);
        return chain.filter(newExchange);
    }

    private void applyInnerHeader(ServerHttpRequest request, ServerHttpRequest.Builder requestBuilder) {
        String zone;
        String environment;
        String region;
        GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-service-group", this.pluginAdapter.getGroup(), this.gatewayHeaderPriority);
        GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-service-type", this.pluginAdapter.getServiceType(), false);
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-service-app-id", serviceAppId, false);
        }
        GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-service-id", this.pluginAdapter.getServiceId(), false);
        GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-service-address", this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort(), false);
        String version = this.pluginAdapter.getVersion();
        if (StringUtils.isNotEmpty((CharSequence)version) && !StringUtils.equals((CharSequence)version, (CharSequence)"default")) {
            GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-service-version", version, false);
        }
        if (StringUtils.isNotEmpty((CharSequence)(region = this.pluginAdapter.getRegion())) && !StringUtils.equals((CharSequence)region, (CharSequence)"default")) {
            GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-service-region", region, false);
        }
        if (StringUtils.isNotEmpty((CharSequence)(environment = this.pluginAdapter.getEnvironment())) && !StringUtils.equals((CharSequence)environment, (CharSequence)"default")) {
            GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-service-env", environment, false);
        }
        if (StringUtils.isNotEmpty((CharSequence)(zone = this.pluginAdapter.getZone())) && !StringUtils.equals((CharSequence)zone, (CharSequence)"default")) {
            GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-service-zone", zone, false);
        }
    }

    private void applyOuterHeader(ServerHttpRequest request, ServerHttpRequest.Builder requestBuilder) {
        Map<String, String> externalHeaderMap;
        String routeEnvironment = this.getRouteEnvironment();
        if (StringUtils.isNotEmpty((CharSequence)routeEnvironment)) {
            GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-env", routeEnvironment, false);
        }
        if (MapUtils.isNotEmpty(externalHeaderMap = this.getExternalHeaderMap())) {
            for (Map.Entry<String, String> entry : externalHeaderMap.entrySet()) {
                String string = entry.getKey();
                String value = entry.getValue();
                GatewayStrategyFilterResolver.setHeader(request, requestBuilder, string, value, this.gatewayHeaderPriority);
            }
        }
        if (this.gatewayCoreHeaderTransmissionEnabled.booleanValue()) {
            Map internalHeaderMap = this.strategyWrapper.getHeaderMap();
            if (MapUtils.isNotEmpty((Map)internalHeaderMap)) {
                for (Map.Entry entry : internalHeaderMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    GatewayStrategyFilterResolver.setHeader(request, requestBuilder, key, value, this.gatewayHeaderPriority);
                }
            }
            String string = this.getRouteVersion();
            String string2 = this.getRouteRegion();
            String routeAddress = this.getRouteAddress();
            String routeVersionWeight = this.getRouteVersionWeight();
            String routeRegionWeight = this.getRouteRegionWeight();
            String routeVersionPrefer = this.getRouteVersionPrefer();
            String routeVersionFailover = this.getRouteVersionFailover();
            String routeRegionTransfer = this.getRouteRegionTransfer();
            String routeRegionFailover = this.getRouteRegionFailover();
            String routeEnvironmentFailover = this.getRouteEnvironmentFailover();
            String routeZoneFailover = this.getRouteZoneFailover();
            String routeAddressFailover = this.getRouteAddressFailover();
            String routeIdBlacklist = this.getRouteIdBlacklist();
            String routeAddressBlacklist = this.getRouteAddressBlacklist();
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-version", string, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-version", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)string2)) {
                GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-region", string2, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-region", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeAddress)) {
                GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-address", routeAddress, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-address", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeVersionWeight)) {
                GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-version-weight", routeVersionWeight, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-version-weight", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeRegionWeight)) {
                GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-region-weight", routeRegionWeight, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-region-weight", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeVersionPrefer)) {
                GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-version-prefer", routeVersionPrefer, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-version-prefer", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeVersionFailover)) {
                GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-version-failover", routeVersionFailover, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-version-failover", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeRegionTransfer)) {
                GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-region-transfer", routeRegionTransfer, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-region-transfer", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeRegionFailover)) {
                GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-region-failover", routeRegionFailover, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-region-failover", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeEnvironmentFailover)) {
                GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-env-failover", routeEnvironmentFailover, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-env-failover", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeZoneFailover)) {
                GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-zone-failover", routeZoneFailover, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-zone-failover", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeAddressFailover)) {
                GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-address-failover", routeAddressFailover, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-address-failover", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeIdBlacklist)) {
                GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-id-blacklist", routeIdBlacklist, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-id-blacklist", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeAddressBlacklist)) {
                GatewayStrategyFilterResolver.setHeader(request, requestBuilder, "n-d-address-blacklist", routeAddressBlacklist, this.gatewayHeaderPriority);
            } else {
                GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-address-blacklist", this.gatewayHeaderPriority, this.gatewayOriginalHeaderIgnored);
            }
        } else {
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-version");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-region");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-address");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-version-weight");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-region-weight");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-version-prefer");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-version-failover");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-region-transfer");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-region-failover");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-env-failover");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-zone-failover");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-address-failover");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-id-blacklist");
            GatewayStrategyFilterResolver.ignoreHeader(requestBuilder, "n-d-address-blacklist");
        }
    }

    public Map<String, String> getExternalHeaderMap() {
        return null;
    }

    public PluginAdapter getPluginAdapter() {
        return this.pluginAdapter;
    }
}

