/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.gateway.filter;

import com.nepxion.discovery.common.util.ReflectionUtil;
import com.nepxion.discovery.plugin.strategy.gateway.filter.GatewayStrategyFilter;
import com.nepxion.discovery.plugin.strategy.monitor.StrategySpan;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyTracerContext;
import org.apache.skywalking.apm.agent.core.context.TracingContext;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractTracingSpan;
import org.apache.skywalking.apm.agent.core.context.trace.EntrySpan;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SkyWalkingGatewayStrategyFilter
implements GatewayStrategyFilter {
    public static final String SKYWALING_SPAN = "SKYWALING_SPAN";
    public static final String OWNER = "owner";

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        String traceId = null;
        try {
            EntrySpan entrySpan = (EntrySpan)exchange.getAttribute(SKYWALING_SPAN);
            traceId = this.getTraceId((AbstractTracingSpan)entrySpan);
        }
        catch (Exception entrySpan) {
            // empty catch block
        }
        StrategySpan strategySpan = new StrategySpan();
        strategySpan.setTraceId(traceId != null ? traceId : "ignored");
        strategySpan.setSpanId("ignored");
        StrategyTracerContext.getCurrentContext().setSpan((Object)strategySpan);
        return chain.filter(exchange);
    }

    private String getTraceId(AbstractTracingSpan tracingSpan) throws Exception {
        if (tracingSpan == null) {
            return null;
        }
        Object owner = ReflectionUtil.getValue(AbstractTracingSpan.class, (Object)tracingSpan, (String)OWNER);
        if (owner instanceof TracingContext) {
            TracingContext tracingContext = (TracingContext)owner;
            return tracingContext.getReadablePrimaryTraceId();
        }
        return null;
    }
}

