/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.gateway.route;

import com.fasterxml.jackson.core.type.TypeReference;
import com.nepxion.discovery.common.entity.GatewayStrategyRouteEntity;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.common.future.DiscoveryFutureCallback;
import com.nepxion.discovery.common.future.DiscoveryFutureResolver;
import com.nepxion.discovery.common.thread.DiscoveryThreadPoolFactory;
import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.plugin.framework.event.PluginPublisher;
import com.nepxion.discovery.plugin.strategy.gateway.event.GatewayStrategyRouteAddedEvent;
import com.nepxion.discovery.plugin.strategy.gateway.event.GatewayStrategyRouteDeletedEvent;
import com.nepxion.discovery.plugin.strategy.gateway.event.GatewayStrategyRouteModifiedEvent;
import com.nepxion.discovery.plugin.strategy.gateway.event.GatewayStrategyRouteUpdatedAllEvent;
import com.nepxion.discovery.plugin.strategy.gateway.route.GatewayStrategyRoute;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.config.GatewayProperties;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.cloud.gateway.route.RouteDefinitionWriter;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractGatewayStrategyRoute
implements GatewayStrategyRoute,
ApplicationEventPublisherAware {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGatewayStrategyRoute.class);
    private ExecutorService executorService = DiscoveryThreadPoolFactory.getExecutorService((String)"gateway-route");
    @Autowired
    private RouteDefinitionLocator routeDefinitionLocator;
    @Autowired
    private RouteDefinitionWriter routeDefinitionWriter;
    @Autowired
    private GatewayProperties gatewayProperties;
    @Autowired
    private PluginPublisher pluginPublisher;
    private ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public synchronized void add(GatewayStrategyRouteEntity gatewayStrategyRouteEntity) {
        String routeId;
        if (gatewayStrategyRouteEntity == null) {
            throw new DiscoveryException("Gateway dynamic route is null");
        }
        Map<String, RouteDefinition> routeDefinitionMap = this.locateRoutes();
        if (routeDefinitionMap.containsKey(routeId = gatewayStrategyRouteEntity.getId())) {
            throw new DiscoveryException("Gateway dynamic route for routeId=[" + routeId + "] is duplicated");
        }
        RouteDefinition routeDefinition = this.convertRoute(gatewayStrategyRouteEntity);
        this.addRoute(routeDefinition);
        LOG.info("Added Gateway dynamic route={}", (Object)routeDefinition);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RefreshRoutesEvent((Object)this));
        this.pluginPublisher.asyncPublish((Object)new GatewayStrategyRouteAddedEvent(gatewayStrategyRouteEntity));
    }

    @Override
    public synchronized void modify(GatewayStrategyRouteEntity gatewayStrategyRouteEntity) {
        String routeId;
        if (gatewayStrategyRouteEntity == null) {
            throw new DiscoveryException("Gateway dynamic route is null");
        }
        Map<String, RouteDefinition> routeDefinitionMap = this.locateRoutes();
        if (!routeDefinitionMap.containsKey(routeId = gatewayStrategyRouteEntity.getId())) {
            throw new DiscoveryException("Gateway dynamic route for routeId=[" + routeId + "] isn't found");
        }
        RouteDefinition routeDefinition = this.convertRoute(gatewayStrategyRouteEntity);
        this.modifyRoute(routeDefinition);
        LOG.info("Modified Gateway dynamic route={}", (Object)routeDefinition);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RefreshRoutesEvent((Object)this));
        this.pluginPublisher.asyncPublish((Object)new GatewayStrategyRouteModifiedEvent(gatewayStrategyRouteEntity));
    }

    @Override
    public synchronized void delete(String routeId) {
        if (StringUtils.isEmpty((CharSequence)routeId)) {
            throw new DiscoveryException("RouteId is empty");
        }
        Map<String, RouteDefinition> routeDefinitionMap = this.locateRoutes();
        RouteDefinition routeDefinition = routeDefinitionMap.get(routeId);
        if (routeDefinition == null) {
            throw new DiscoveryException("Gateway dynamic route for routeId=[" + routeId + "] isn't found");
        }
        this.deleteRoute(routeDefinition);
        LOG.info("Deleted Gateway dynamic route for routeId={}", (Object)routeId);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RefreshRoutesEvent((Object)this));
        this.pluginPublisher.asyncPublish((Object)new GatewayStrategyRouteDeletedEvent(routeId));
    }

    @Override
    public synchronized void updateAll(List<GatewayStrategyRouteEntity> gatewayStrategyRouteEntityList) {
        RouteDefinition routeDefinition;
        String routeId;
        if (gatewayStrategyRouteEntityList == null) {
            throw new DiscoveryException("Gateway dynamic routes are null");
        }
        boolean isIdDuplicated = this.isIdDuplicated(gatewayStrategyRouteEntityList);
        if (isIdDuplicated) {
            throw new DiscoveryException("Gateway dynamic routes have duplicated routeIds");
        }
        Map<String, RouteDefinition> dynamicRouteDefinitionMap = gatewayStrategyRouteEntityList.stream().collect(Collectors.toMap(GatewayStrategyRouteEntity::getId, this::convertRoute));
        Map<String, RouteDefinition> currentRouteDefinitionMap = this.locateRoutes();
        ArrayList<RouteDefinition> addRouteDefinitionList = new ArrayList<RouteDefinition>(dynamicRouteDefinitionMap.size());
        ArrayList<RouteDefinition> modifyRouteDefinitionList = new ArrayList<RouteDefinition>(dynamicRouteDefinitionMap.size());
        ArrayList<RouteDefinition> deleteRouteDefinitionList = new ArrayList<RouteDefinition>(dynamicRouteDefinitionMap.size());
        for (Map.Entry<String, RouteDefinition> entry : dynamicRouteDefinitionMap.entrySet()) {
            routeId = entry.getKey();
            routeDefinition = entry.getValue();
            if (currentRouteDefinitionMap.containsKey(routeId)) continue;
            addRouteDefinitionList.add(routeDefinition);
        }
        for (Map.Entry<String, RouteDefinition> entry : dynamicRouteDefinitionMap.entrySet()) {
            RouteDefinition currentRouteDefinition;
            routeId = entry.getKey();
            routeDefinition = entry.getValue();
            if (!currentRouteDefinitionMap.containsKey(routeId) || (currentRouteDefinition = currentRouteDefinitionMap.get(routeId)).equals((Object)routeDefinition)) continue;
            modifyRouteDefinitionList.add(routeDefinition);
        }
        for (Map.Entry<String, RouteDefinition> entry : currentRouteDefinitionMap.entrySet()) {
            routeId = entry.getKey();
            routeDefinition = entry.getValue();
            if (dynamicRouteDefinitionMap.containsKey(routeId)) continue;
            deleteRouteDefinitionList.add(routeDefinition);
        }
        for (RouteDefinition routeDefinition2 : addRouteDefinitionList) {
            this.addRoute(routeDefinition2);
        }
        for (RouteDefinition routeDefinition2 : modifyRouteDefinitionList) {
            this.modifyRoute(routeDefinition2);
        }
        for (RouteDefinition routeDefinition2 : deleteRouteDefinitionList) {
            this.deleteRoute(routeDefinition2);
        }
        LOG.info("--- Gateway Dynamic Routes Update Information ----");
        LOG.info("Total count={}", (Object)gatewayStrategyRouteEntityList.size());
        LOG.info("Added count={}", (Object)addRouteDefinitionList.size());
        LOG.info("Modified count={}", (Object)modifyRouteDefinitionList.size());
        LOG.info("Deleted count={}", (Object)deleteRouteDefinitionList.size());
        LOG.info("--------------------------------------------------");
        if (addRouteDefinitionList.isEmpty() && modifyRouteDefinitionList.isEmpty() && deleteRouteDefinitionList.isEmpty()) {
            return;
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RefreshRoutesEvent((Object)this));
        this.pluginPublisher.asyncPublish((Object)new GatewayStrategyRouteUpdatedAllEvent(gatewayStrategyRouteEntityList));
    }

    @Override
    public synchronized void updateAll(String gatewayStrategyRouteConfig) {
        if (StringUtils.isBlank((CharSequence)gatewayStrategyRouteConfig)) {
            gatewayStrategyRouteConfig = "[]";
        }
        List gatewayStrategyRouteEntityList = (List)JsonUtil.fromJson((String)gatewayStrategyRouteConfig, (TypeReference)new TypeReference<List<GatewayStrategyRouteEntity>>(){});
        this.updateAll(gatewayStrategyRouteEntityList);
    }

    @Override
    public GatewayStrategyRouteEntity view(String routeId) {
        if (StringUtils.isEmpty((CharSequence)routeId)) {
            throw new DiscoveryException("RouteId is empty");
        }
        RouteDefinition routeDefinition = this.locateRoutes().get(routeId);
        if (routeDefinition == null) {
            throw new DiscoveryException("Gateway dynamic route for routeId=[" + routeId + "] isn't found");
        }
        return this.convertRoute(routeDefinition);
    }

    @Override
    public List<GatewayStrategyRouteEntity> viewAll() {
        ArrayList<GatewayStrategyRouteEntity> gatewayStrategyRouteEntityList = new ArrayList<GatewayStrategyRouteEntity>();
        Map<String, RouteDefinition> routeDefinitionMap = this.locateRoutes();
        for (Map.Entry<String, RouteDefinition> entry : routeDefinitionMap.entrySet()) {
            RouteDefinition routeDefinition = entry.getValue();
            GatewayStrategyRouteEntity gatewayStrategyRouteEntity = this.convertRoute(routeDefinition);
            gatewayStrategyRouteEntityList.add(gatewayStrategyRouteEntity);
        }
        return gatewayStrategyRouteEntityList;
    }

    public Map<String, RouteDefinition> locateRoutes() {
        final Flux routeDefinitions = this.routeDefinitionLocator.getRouteDefinitions();
        try {
            return (Map)DiscoveryFutureResolver.call((ExecutorService)this.executorService, (DiscoveryFutureCallback)new DiscoveryFutureCallback<Map<String, RouteDefinition>>(){

                public Map<String, RouteDefinition> callback() {
                    List routeDefinitionList = (List)routeDefinitions.collectList().block();
                    return routeDefinitionList.stream().collect(Collectors.toMap(RouteDefinition::getId, RouteDefinition2 -> RouteDefinition2));
                }
            });
        }
        catch (Exception e) {
            return new HashMap<String, RouteDefinition>();
        }
    }

    private boolean isIdDuplicated(List<GatewayStrategyRouteEntity> gatewayStrategyRouteEntityList) {
        TreeSet<GatewayStrategyRouteEntity> gatewayStrategyRouteEntitySet = new TreeSet<GatewayStrategyRouteEntity>(new Comparator<GatewayStrategyRouteEntity>(){

            @Override
            public int compare(GatewayStrategyRouteEntity gatewayStrategyRouteEntity1, GatewayStrategyRouteEntity gatewayStrategyRouteEntity2) {
                return gatewayStrategyRouteEntity1.getId().compareTo(gatewayStrategyRouteEntity2.getId());
            }
        });
        gatewayStrategyRouteEntitySet.addAll(gatewayStrategyRouteEntityList);
        return gatewayStrategyRouteEntitySet.size() < gatewayStrategyRouteEntityList.size();
    }

    public RouteDefinition convertRoute(GatewayStrategyRouteEntity gatewayStrategyRouteEntity) {
        RouteDefinition routeDefinition = new RouteDefinition();
        routeDefinition.setId(gatewayStrategyRouteEntity.getId());
        routeDefinition.setUri(this.convertURI(gatewayStrategyRouteEntity.getUri()));
        List predicateList = gatewayStrategyRouteEntity.getPredicates();
        List userPredicates = gatewayStrategyRouteEntity.getUserPredicates();
        ArrayList<PredicateDefinition> predicateDefinitionList = new ArrayList<PredicateDefinition>(predicateList.size() + userPredicates.size());
        for (String predicate : predicateList) {
            predicateDefinitionList.add(new PredicateDefinition(predicate));
        }
        for (String predicate : userPredicates) {
            PredicateDefinition predicateDefinition = new PredicateDefinition();
            predicateDefinition.setName(predicate.getName());
            predicateDefinition.setArgs(predicate.getArgs());
            predicateDefinitionList.add(predicateDefinition);
        }
        routeDefinition.setPredicates(predicateDefinitionList);
        List filterList = gatewayStrategyRouteEntity.getFilters();
        List userFilters = gatewayStrategyRouteEntity.getUserFilters();
        ArrayList<FilterDefinition> filterDefinitionList = new ArrayList<FilterDefinition>(filterList.size() + userFilters.size());
        for (String filter : filterList) {
            filterDefinitionList.add(new FilterDefinition(filter));
        }
        for (String filter : userFilters) {
            FilterDefinition filterDefinition = new FilterDefinition();
            filterDefinition.setName(filter.getName());
            filterDefinition.setArgs(filter.getArgs());
            filterDefinitionList.add(filterDefinition);
        }
        routeDefinition.setFilters(filterDefinitionList);
        routeDefinition.setOrder(gatewayStrategyRouteEntity.getOrder());
        try {
            routeDefinition.setMetadata(gatewayStrategyRouteEntity.getMetadata());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return routeDefinition;
    }

    public GatewayStrategyRouteEntity convertRoute(RouteDefinition routeDefinition) {
        GatewayStrategyRouteEntity gatewayStrategyRouteEntity = new GatewayStrategyRouteEntity();
        gatewayStrategyRouteEntity.setId(routeDefinition.getId());
        gatewayStrategyRouteEntity.setUri(routeDefinition.getUri().toString());
        gatewayStrategyRouteEntity.setOrder(routeDefinition.getOrder());
        try {
            gatewayStrategyRouteEntity.setMetadata(routeDefinition.getMetadata());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.convertPredicates(routeDefinition.getPredicates(), gatewayStrategyRouteEntity.getPredicates(), gatewayStrategyRouteEntity.getUserPredicates());
        this.convertFilters(routeDefinition.getFilters(), gatewayStrategyRouteEntity.getFilters(), gatewayStrategyRouteEntity.getUserFilters());
        return gatewayStrategyRouteEntity;
    }

    public void convertPredicates(List<PredicateDefinition> predicateDefinitionList, List<String> predicateList, List<GatewayStrategyRouteEntity.Predicate> userPredicateList) {
        for (PredicateDefinition predicateDefinition : predicateDefinitionList) {
            String name = predicateDefinition.getName();
            Map args = predicateDefinition.getArgs();
            boolean internal = this.isInternal(args);
            if (internal) {
                predicateList.add(String.format("%s=%s", name, StringUtils.join(args.values(), (String)",")));
                continue;
            }
            GatewayStrategyRouteEntity.Predicate predicate = new GatewayStrategyRouteEntity.Predicate();
            predicate.setName(predicateDefinition.getName());
            predicate.setArgs(predicateDefinition.getArgs());
            userPredicateList.add(predicate);
        }
    }

    public void convertFilters(List<FilterDefinition> filterDefinitionList, List<String> filterList, List<GatewayStrategyRouteEntity.Filter> userFilterList) {
        for (FilterDefinition filterDefinition : filterDefinitionList) {
            String name = filterDefinition.getName();
            Map args = filterDefinition.getArgs();
            boolean internal = this.isInternal(args);
            if (internal) {
                filterList.add(String.format("%s=%s", name, StringUtils.join(args.values(), (String)",")));
                continue;
            }
            GatewayStrategyRouteEntity.Filter filter = new GatewayStrategyRouteEntity.Filter();
            filter.setName(filterDefinition.getName());
            filter.setArgs(filterDefinition.getArgs());
            userFilterList.add(filter);
        }
    }

    public boolean isInternal(Map<String, String> args) {
        for (Map.Entry<String, String> entry : args.entrySet()) {
            String key = entry.getKey();
            if (!key.contains("_genkey_")) continue;
            return true;
        }
        return false;
    }

    public URI convertURI(String value) {
        URI uri = value.toLowerCase().startsWith("http") || value.toLowerCase().startsWith("https") ? UriComponentsBuilder.fromHttpUrl((String)value).build().toUri() : URI.create(value);
        return uri;
    }

    public void addRoute(RouteDefinition routeDefinition) {
        Disposable disposable = null;
        try {
            disposable = this.routeDefinitionWriter.save(Mono.just((Object)routeDefinition)).subscribe();
        }
        finally {
            if (disposable != null) {
                disposable.dispose();
            }
        }
    }

    public void modifyRoute(RouteDefinition routeDefinition) {
        this.deleteRoute(routeDefinition);
        this.addRoute(routeDefinition);
    }

    public void deleteRoute(final RouteDefinition routeDefinition) {
        Disposable disposable = null;
        try {
            disposable = this.routeDefinitionWriter.delete(Mono.just((Object)routeDefinition.getId())).onErrorResume((Function)new Function<Throwable, Mono<? extends Void>>(){

                @Override
                public Mono<? extends Void> apply(Throwable throwable) {
                    if (throwable instanceof NotFoundException) {
                        AbstractGatewayStrategyRoute.this.gatewayProperties.getRoutes().removeIf(new Predicate<RouteDefinition>(){

                            @Override
                            public boolean test(RouteDefinition routeCandidate) {
                                return routeCandidate.getId().equals(routeDefinition.getId());
                            }
                        });
                        return Mono.empty();
                    }
                    return Mono.error((Throwable)throwable);
                }
            }).subscribe();
        }
        finally {
            if (disposable != null) {
                disposable.dispose();
            }
        }
    }

    public void clearRoutes() {
        Map<String, RouteDefinition> routeDefinitionMap = this.locateRoutes();
        for (Map.Entry<String, RouteDefinition> entry : routeDefinitionMap.entrySet()) {
            RouteDefinition routeDefinition = entry.getValue();
            this.deleteRoute(routeDefinition);
        }
    }
}

