/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.adapter;

import com.nepxion.discovery.plugin.strategy.adapter.DiscoveryEnabledAdapter;
import com.nepxion.discovery.plugin.strategy.adapter.DiscoveryEnabledStrategy;
import com.nepxion.discovery.plugin.strategy.filter.StrategyEnabledFilter;
import com.netflix.loadbalancer.Server;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class DefaultDiscoveryEnabledAdapter
implements DiscoveryEnabledAdapter {
    @Autowired
    protected List<StrategyEnabledFilter> strategyEnabledFilterList;
    @Autowired(required=false)
    protected List<DiscoveryEnabledStrategy> discoveryEnabledStrategyList;

    public void filter(List<? extends Server> servers) {
        for (StrategyEnabledFilter strategyEnabledFilter : this.strategyEnabledFilterList) {
            strategyEnabledFilter.filter(servers);
        }
    }

    public boolean apply(Server server) {
        if (CollectionUtils.isEmpty(this.discoveryEnabledStrategyList)) {
            return true;
        }
        for (DiscoveryEnabledStrategy discoveryEnabledStrategy : this.discoveryEnabledStrategyList) {
            boolean enabled = discoveryEnabledStrategy.apply(server);
            if (enabled) continue;
            return false;
        }
        return true;
    }
}

