/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.aop;

import com.nepxion.discovery.common.entity.InterceptorType;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.context.StrategyHeaderContext;
import com.nepxion.discovery.plugin.strategy.util.StrategyUtil;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractStrategyInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStrategyInterceptor.class);
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected StrategyContextHolder strategyContextHolder;
    @Autowired
    protected StrategyHeaderContext strategyHeaderContext;
    @Value(value="${spring.application.strategy.rest.intercept.debug.enabled:false}")
    protected Boolean interceptDebugEnabled;
    protected List<String> requestHeaderNameList;

    @PostConstruct
    public void initialize() {
        this.requestHeaderNameList = this.strategyHeaderContext.getRequestHeaderNameList();
        InterceptorType interceptorType = this.getInterceptorType();
        LOG.info("--------- Strategy Intercept Information ---------");
        LOG.info("{} desires to intercept customer headers are {}", (Object)interceptorType, this.requestHeaderNameList);
        LOG.info("--------------------------------------------------");
    }

    protected void interceptInputHeader() {
        if (!this.interceptDebugEnabled.booleanValue()) {
            return;
        }
        Enumeration<String> headerNames = this.strategyContextHolder.getHeaderNames();
        if (headerNames != null) {
            InterceptorType interceptorType = this.getInterceptorType();
            Logger log = this.getInterceptorLogger();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n");
            switch (interceptorType) {
                case FEIGN: {
                    stringBuilder.append("--------- Feign Intercept Input Header Information ---------").append("\n");
                    break;
                }
                case REST_TEMPLATE: {
                    stringBuilder.append("----- RestTemplate Intercept Input Header Information ------").append("\n");
                    break;
                }
                case WEB_CLIENT: {
                    stringBuilder.append("------- WebClient Intercept Input Header Information -------").append("\n");
                }
            }
            while (headerNames.hasMoreElements()) {
                String headerName = headerNames.nextElement();
                boolean isHeaderContains = this.isHeaderContains(headerName.toLowerCase());
                if (!isHeaderContains) continue;
                String headerValue = this.strategyContextHolder.getHeader(headerName);
                stringBuilder.append(headerName + "=" + headerValue).append("\n");
            }
            stringBuilder.append("------------------------------------------------------------");
            log.info(stringBuilder.toString());
        }
    }

    protected boolean isHeaderContains(String headerName) {
        return headerName.startsWith("n-d-") || this.requestHeaderNameList.contains(headerName);
    }

    protected boolean isHeaderContainsExcludeInner(String headerName) {
        return this.isHeaderContains(headerName) && !StrategyUtil.isInnerHeaderContains(headerName);
    }

    protected abstract InterceptorType getInterceptorType();

    protected abstract Logger getInterceptorLogger();
}

