/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.aop;

import com.nepxion.discovery.common.entity.InterceptorType;
import com.nepxion.discovery.plugin.strategy.aop.AbstractStrategyInterceptor;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.util.StrategyUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class FeignStrategyInterceptor
extends AbstractStrategyInterceptor
implements RequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(FeignStrategyInterceptor.class);
    @Autowired
    protected StrategyContextHolder strategyContextHolder;
    @Value(value="${spring.application.strategy.feign.core.header.transmission.enabled:true}")
    protected Boolean feignCoreHeaderTransmissionEnabled;

    public void apply(RequestTemplate requestTemplate) {
        this.interceptInputHeader();
        this.applyInnerHeader(requestTemplate);
        this.applyOuterHeader(requestTemplate);
        this.interceptOutputHeader(requestTemplate);
    }

    private void applyInnerHeader(RequestTemplate requestTemplate) {
        String zone;
        String environment;
        String region;
        requestTemplate.header("n-d-service-group", new String[]{this.pluginAdapter.getGroup()});
        requestTemplate.header("n-d-service-type", new String[]{this.pluginAdapter.getServiceType()});
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            requestTemplate.header("n-d-service-app-id", new String[]{serviceAppId});
        }
        requestTemplate.header("n-d-service-id", new String[]{this.pluginAdapter.getServiceId()});
        requestTemplate.header("n-d-service-address", new String[]{this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort()});
        String version = this.pluginAdapter.getVersion();
        if (StringUtils.isNotEmpty((CharSequence)version) && !StringUtils.equals((CharSequence)version, (CharSequence)"default")) {
            requestTemplate.header("n-d-service-version", new String[]{version});
        }
        if (StringUtils.isNotEmpty((CharSequence)(region = this.pluginAdapter.getRegion())) && !StringUtils.equals((CharSequence)region, (CharSequence)"default")) {
            requestTemplate.header("n-d-service-region", new String[]{region});
        }
        if (StringUtils.isNotEmpty((CharSequence)(environment = this.pluginAdapter.getEnvironment())) && !StringUtils.equals((CharSequence)environment, (CharSequence)"default")) {
            requestTemplate.header("n-d-service-env", new String[]{environment});
        }
        if (StringUtils.isNotEmpty((CharSequence)(zone = this.pluginAdapter.getZone())) && !StringUtils.equals((CharSequence)zone, (CharSequence)"default")) {
            requestTemplate.header("n-d-service-zone", new String[]{zone});
        }
    }

    private void applyOuterHeader(RequestTemplate requestTemplate) {
        Enumeration<String> headerNames = this.strategyContextHolder.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = headerNames.nextElement();
                String headerValue = this.strategyContextHolder.getHeader(headerName);
                boolean isHeaderContains = this.isHeaderContainsExcludeInner(headerName.toLowerCase());
                if (!isHeaderContains) continue;
                if (this.feignCoreHeaderTransmissionEnabled.booleanValue()) {
                    requestTemplate.header(headerName, new String[]{headerValue});
                    continue;
                }
                boolean isCoreHeaderContains = StrategyUtil.isCoreHeaderContains(headerName);
                if (isCoreHeaderContains) continue;
                requestTemplate.header(headerName, new String[]{headerValue});
            }
        }
        if (this.feignCoreHeaderTransmissionEnabled.booleanValue()) {
            String routeAddressBlacklist;
            String routeIdBlacklist;
            String routeAddressFailover;
            String routeZoneFailover;
            String routeEnvironmentFailover;
            String routeRegionFailover;
            String routeRegionTransfer;
            String routeVersionFailover;
            String routeVersionPrefer;
            String routeRegionWeight;
            String routeVersionWeight;
            String routeAddress;
            String routeEnvironment;
            String routeRegion;
            String routeVersion;
            Map headers = requestTemplate.headers();
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-version"))) && StringUtils.isNotEmpty((CharSequence)(routeVersion = this.strategyContextHolder.getRouteVersion()))) {
                requestTemplate.header("n-d-version", new String[]{routeVersion});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-region"))) && StringUtils.isNotEmpty((CharSequence)(routeRegion = this.strategyContextHolder.getRouteRegion()))) {
                requestTemplate.header("n-d-region", new String[]{routeRegion});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-env"))) && StringUtils.isNotEmpty((CharSequence)(routeEnvironment = this.strategyContextHolder.getRouteEnvironment()))) {
                requestTemplate.header("n-d-env", new String[]{routeEnvironment});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-address"))) && StringUtils.isNotEmpty((CharSequence)(routeAddress = this.strategyContextHolder.getRouteAddress()))) {
                requestTemplate.header("n-d-address", new String[]{routeAddress});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-version-weight"))) && StringUtils.isNotEmpty((CharSequence)(routeVersionWeight = this.strategyContextHolder.getRouteVersionWeight()))) {
                requestTemplate.header("n-d-version-weight", new String[]{routeVersionWeight});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-region-weight"))) && StringUtils.isNotEmpty((CharSequence)(routeRegionWeight = this.strategyContextHolder.getRouteRegionWeight()))) {
                requestTemplate.header("n-d-region-weight", new String[]{routeRegionWeight});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-version-prefer"))) && StringUtils.isNotEmpty((CharSequence)(routeVersionPrefer = this.strategyContextHolder.getRouteVersionPrefer()))) {
                requestTemplate.header("n-d-version-prefer", new String[]{routeVersionPrefer});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-version-failover"))) && StringUtils.isNotEmpty((CharSequence)(routeVersionFailover = this.strategyContextHolder.getRouteVersionFailover()))) {
                requestTemplate.header("n-d-version-failover", new String[]{routeVersionFailover});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-region-transfer"))) && StringUtils.isNotEmpty((CharSequence)(routeRegionTransfer = this.strategyContextHolder.getRouteRegionTransfer()))) {
                requestTemplate.header("n-d-region-transfer", new String[]{routeRegionTransfer});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-region-failover"))) && StringUtils.isNotEmpty((CharSequence)(routeRegionFailover = this.strategyContextHolder.getRouteRegionFailover()))) {
                requestTemplate.header("n-d-region-failover", new String[]{routeRegionFailover});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-env-failover"))) && StringUtils.isNotEmpty((CharSequence)(routeEnvironmentFailover = this.strategyContextHolder.getRouteEnvironmentFailover()))) {
                requestTemplate.header("n-d-env-failover", new String[]{routeEnvironmentFailover});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-zone-failover"))) && StringUtils.isNotEmpty((CharSequence)(routeZoneFailover = this.strategyContextHolder.getRouteZoneFailover()))) {
                requestTemplate.header("n-d-zone-failover", new String[]{routeZoneFailover});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-address-failover"))) && StringUtils.isNotEmpty((CharSequence)(routeAddressFailover = this.strategyContextHolder.getRouteAddressFailover()))) {
                requestTemplate.header("n-d-address-failover", new String[]{routeAddressFailover});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-id-blacklist"))) && StringUtils.isNotEmpty((CharSequence)(routeIdBlacklist = this.strategyContextHolder.getRouteIdBlacklist()))) {
                requestTemplate.header("n-d-id-blacklist", new String[]{routeIdBlacklist});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-address-blacklist"))) && StringUtils.isNotEmpty((CharSequence)(routeAddressBlacklist = this.strategyContextHolder.getRouteAddressBlacklist()))) {
                requestTemplate.header("n-d-address-blacklist", new String[]{routeAddressBlacklist});
            }
        }
    }

    private void interceptOutputHeader(RequestTemplate requestTemplate) {
        if (!this.interceptDebugEnabled.booleanValue()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append("-------- Feign Intercept Output Header Information ---------").append("\n");
        Map headers = requestTemplate.headers();
        for (Map.Entry entry : headers.entrySet()) {
            String headerName = (String)entry.getKey();
            boolean isHeaderContains = this.isHeaderContains(headerName.toLowerCase());
            if (!isHeaderContains) continue;
            Collection headerValue = (Collection)entry.getValue();
            stringBuilder.append(headerName + "=" + headerValue).append("\n");
        }
        stringBuilder.append("------------------------------------------------------------");
        LOG.info(stringBuilder.toString());
    }

    @Override
    protected InterceptorType getInterceptorType() {
        return InterceptorType.FEIGN;
    }

    @Override
    protected Logger getInterceptorLogger() {
        return LOG;
    }
}

