/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.aop;

import com.nepxion.discovery.common.entity.InterceptorType;
import com.nepxion.discovery.plugin.strategy.aop.AbstractStrategyInterceptor;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.util.StrategyUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class RestTemplateStrategyInterceptor
extends AbstractStrategyInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RestTemplateStrategyInterceptor.class);
    @Autowired
    protected StrategyContextHolder strategyContextHolder;
    @Value(value="${spring.application.strategy.rest.template.core.header.transmission.enabled:true}")
    protected Boolean restTemplateCoreHeaderTransmissionEnabled;

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.interceptInputHeader();
        this.applyInnerHeader(request);
        this.applyOuterHeader(request);
        this.interceptOutputHeader(request);
        return execution.execute(request, body);
    }

    private void applyInnerHeader(HttpRequest request) {
        String zone;
        String environment;
        String region;
        HttpHeaders headers = request.getHeaders();
        headers.add("n-d-service-group", this.pluginAdapter.getGroup());
        headers.add("n-d-service-type", this.pluginAdapter.getServiceType());
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            headers.add("n-d-service-app-id", serviceAppId);
        }
        headers.add("n-d-service-id", this.pluginAdapter.getServiceId());
        headers.add("n-d-service-address", this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort());
        String version = this.pluginAdapter.getVersion();
        if (StringUtils.isNotEmpty((CharSequence)version) && !StringUtils.equals((CharSequence)version, (CharSequence)"default")) {
            headers.add("n-d-service-version", version);
        }
        if (StringUtils.isNotEmpty((CharSequence)(region = this.pluginAdapter.getRegion())) && !StringUtils.equals((CharSequence)region, (CharSequence)"default")) {
            headers.add("n-d-service-region", region);
        }
        if (StringUtils.isNotEmpty((CharSequence)(environment = this.pluginAdapter.getEnvironment())) && !StringUtils.equals((CharSequence)environment, (CharSequence)"default")) {
            headers.add("n-d-service-env", environment);
        }
        if (StringUtils.isNotEmpty((CharSequence)(zone = this.pluginAdapter.getZone())) && !StringUtils.equals((CharSequence)zone, (CharSequence)"default")) {
            headers.add("n-d-service-zone", zone);
        }
    }

    private void applyOuterHeader(HttpRequest request) {
        HttpHeaders headers;
        Enumeration<String> headerNames = this.strategyContextHolder.getHeaderNames();
        if (headerNames != null) {
            headers = request.getHeaders();
            while (headerNames.hasMoreElements()) {
                String headerName = headerNames.nextElement();
                String headerValue = this.strategyContextHolder.getHeader(headerName);
                boolean isHeaderContains = this.isHeaderContainsExcludeInner(headerName.toLowerCase());
                if (!isHeaderContains) continue;
                if (this.restTemplateCoreHeaderTransmissionEnabled.booleanValue()) {
                    headers.add(headerName, headerValue);
                    continue;
                }
                boolean isCoreHeaderContains = StrategyUtil.isCoreHeaderContains(headerName);
                if (isCoreHeaderContains) continue;
                headers.add(headerName, headerValue);
            }
        }
        if (this.restTemplateCoreHeaderTransmissionEnabled.booleanValue()) {
            String routeAddressBlacklist;
            String routeIdBlacklist;
            String routeAddressFailover;
            String routeZoneFailover;
            String routeEnvironmentFailover;
            String routeRegionFailover;
            String routeRegionTransfer;
            String routeVersionFailover;
            String routeVersionPrefer;
            String routeRegionWeight;
            String routeVersionWeight;
            String routeAddress;
            String routeEnvironment;
            String routeRegion;
            String routeVersion;
            headers = request.getHeaders();
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-version")) && StringUtils.isNotEmpty((CharSequence)(routeVersion = this.strategyContextHolder.getRouteVersion()))) {
                headers.add("n-d-version", routeVersion);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-region")) && StringUtils.isNotEmpty((CharSequence)(routeRegion = this.strategyContextHolder.getRouteRegion()))) {
                headers.add("n-d-region", routeRegion);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-env")) && StringUtils.isNotEmpty((CharSequence)(routeEnvironment = this.strategyContextHolder.getRouteEnvironment()))) {
                headers.add("n-d-env", routeEnvironment);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-address")) && StringUtils.isNotEmpty((CharSequence)(routeAddress = this.strategyContextHolder.getRouteAddress()))) {
                headers.add("n-d-address", routeAddress);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-version-weight")) && StringUtils.isNotEmpty((CharSequence)(routeVersionWeight = this.strategyContextHolder.getRouteVersionWeight()))) {
                headers.add("n-d-version-weight", routeVersionWeight);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-region-weight")) && StringUtils.isNotEmpty((CharSequence)(routeRegionWeight = this.strategyContextHolder.getRouteRegionWeight()))) {
                headers.add("n-d-region-weight", routeRegionWeight);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-version-prefer")) && StringUtils.isNotEmpty((CharSequence)(routeVersionPrefer = this.strategyContextHolder.getRouteVersionPrefer()))) {
                headers.add("n-d-version-prefer", routeVersionPrefer);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-version-failover")) && StringUtils.isNotEmpty((CharSequence)(routeVersionFailover = this.strategyContextHolder.getRouteVersionFailover()))) {
                headers.add("n-d-version-failover", routeVersionFailover);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-region-transfer")) && StringUtils.isNotEmpty((CharSequence)(routeRegionTransfer = this.strategyContextHolder.getRouteRegionTransfer()))) {
                headers.add("n-d-region-transfer", routeRegionTransfer);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-region-failover")) && StringUtils.isNotEmpty((CharSequence)(routeRegionFailover = this.strategyContextHolder.getRouteRegionFailover()))) {
                headers.add("n-d-region-failover", routeRegionFailover);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-env-failover")) && StringUtils.isNotEmpty((CharSequence)(routeEnvironmentFailover = this.strategyContextHolder.getRouteEnvironmentFailover()))) {
                headers.add("n-d-env-failover", routeEnvironmentFailover);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-zone-failover")) && StringUtils.isNotEmpty((CharSequence)(routeZoneFailover = this.strategyContextHolder.getRouteZoneFailover()))) {
                headers.add("n-d-zone-failover", routeZoneFailover);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-address-failover")) && StringUtils.isNotEmpty((CharSequence)(routeAddressFailover = this.strategyContextHolder.getRouteAddressFailover()))) {
                headers.add("n-d-address-failover", routeAddressFailover);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-id-blacklist")) && StringUtils.isNotEmpty((CharSequence)(routeIdBlacklist = this.strategyContextHolder.getRouteIdBlacklist()))) {
                headers.add("n-d-id-blacklist", routeIdBlacklist);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-address-blacklist")) && StringUtils.isNotEmpty((CharSequence)(routeAddressBlacklist = this.strategyContextHolder.getRouteAddressBlacklist()))) {
                headers.add("n-d-address-blacklist", routeAddressBlacklist);
            }
        }
    }

    private void interceptOutputHeader(HttpRequest request) {
        if (!this.interceptDebugEnabled.booleanValue()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append("----- RestTemplate Intercept Output Header Information -----").append("\n");
        HttpHeaders headers = request.getHeaders();
        for (Map.Entry header : headers.entrySet()) {
            String headerName = (String)header.getKey();
            boolean isHeaderContains = this.isHeaderContains(headerName.toLowerCase());
            if (!isHeaderContains) continue;
            List headerValue = (List)header.getValue();
            stringBuilder.append(headerName + "=" + headerValue).append("\n");
        }
        stringBuilder.append("------------------------------------------------------------");
        LOG.info(stringBuilder.toString());
    }

    @Override
    protected InterceptorType getInterceptorType() {
        return InterceptorType.REST_TEMPLATE;
    }

    @Override
    protected Logger getInterceptorLogger() {
        return LOG;
    }
}

